/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.util.SealUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerboundShootFromRotationPacket {
    private final ResourceLocation entityTypeId;
    private final float x;
    float y;
    float z;
    private final float vel;
    private final float xRot;
    private final float yRot;
    float inaccuracy;
    private final ItemStack stack;

    public ServerboundShootFromRotationPacket(ItemStack stack, EntityType<? extends Projectile> entityType, Vec3 pos, float xRot, float yRot, float vel, float inaccuracy) {
        this.stack = stack;
        this.entityTypeId = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        this.x = (float)pos.m_7096_();
        this.y = (float)pos.m_7098_();
        this.z = (float)pos.m_7094_();
        this.xRot = xRot;
        this.yRot = yRot;
        this.vel = vel;
        this.inaccuracy = inaccuracy;
    }

    public ServerboundShootFromRotationPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.entityTypeId = buf.m_130281_();
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.xRot = buf.readFloat();
        this.yRot = buf.readFloat();
        this.vel = buf.readFloat();
        this.inaccuracy = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.m_130085_(this.entityTypeId);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.xRot);
        buf.writeFloat(this.yRot);
        buf.writeFloat(this.vel);
        buf.writeFloat(this.inaccuracy);
    }

    public static void handle(ServerboundShootFromRotationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            DelayedTaskScheduler.queueServerWork((Level)level, 6, () -> {
                Entity entity;
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(packet.entityTypeId);
                if (entityType != null && (entity = entityType.m_20615_((Level)level)) instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    projectile.m_6034_((double)packet.x, (double)packet.y, (double)packet.z);
                    projectile.m_37251_((Entity)player, packet.xRot, packet.yRot, 0.0f, packet.vel, packet.inaccuracy);
                    projectile.m_5602_((Entity)player);
                    SealUtils.SEAL_TYPE sealType = SealUtils.getSealType(packet.stack);
                    if (sealType != null) {
                        projectile.getCapability(BrutalityCapabilities.SEAL_TYPE_CAP).ifPresent(cap -> cap.setSealType(sealType));
                    }
                    level.m_7967_((Entity)projectile);
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

