/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.particle.providers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.goo.brutality.particle.base.FlatParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FlatParticleData<T extends ParticleOptions>
implements ParticleOptions {
    public static final Codec<FlatParticleData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.PARTICLE_TYPES.getCodec().fieldOf("type").forGetter(data -> data.type), (App)Codec.FLOAT.fieldOf("radius").forGetter(data -> Float.valueOf(data.radius)), (App)Codec.FLOAT.fieldOf("rotX").forGetter(data -> Float.valueOf(data.rotX)), (App)Codec.FLOAT.fieldOf("rotY").forGetter(data -> Float.valueOf(data.rotY)), (App)Codec.FLOAT.fieldOf("rotZ").forGetter(data -> Float.valueOf(data.rotZ)), (App)Codec.FLOAT.fieldOf("xOffset").forGetter(data -> Float.valueOf(data.xOffset)), (App)Codec.FLOAT.fieldOf("yOffset").forGetter(data -> Float.valueOf(data.yOffset)), (App)Codec.FLOAT.fieldOf("zOffset").forGetter(data -> Float.valueOf(data.zOffset)), (App)Codec.INT.optionalFieldOf("entityID").forGetter(data -> data.entityID == null ? Optional.empty() : Optional.of(data.entityID))).apply((Applicative)instance, (type, radius, rotX, rotY, rotZ, xOffset, yOffset, zOffset, entityID) -> new FlatParticleData(type, radius.floatValue(), rotX.floatValue(), rotY.floatValue(), rotZ.floatValue(), xOffset.floatValue(), yOffset.floatValue(), zOffset.floatValue(), entityID.orElse(null))));
    protected final ParticleType<T> type;
    protected final float radius;
    protected final float rotX;
    protected final float rotY;
    protected final float rotZ;
    protected final float xOffset;
    protected final float yOffset;
    protected final float zOffset;
    protected final Integer entityID;
    public static final ParticleOptions.Deserializer<FlatParticleData<?>> DESERIALIZER = new ParticleOptions.Deserializer<FlatParticleData<?>>(){

        @NotNull
        public FlatParticleData<?> fromCommand(@NotNull ParticleType<FlatParticleData<?>> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float radius = reader.readFloat();
            reader.expect(' ');
            float rotX = reader.readFloat();
            reader.expect(' ');
            float rotY = reader.readFloat();
            reader.expect(' ');
            float rotZ = reader.readFloat();
            reader.expect(' ');
            float xOffset = reader.readFloat();
            reader.expect(' ');
            float yOffset = reader.readFloat();
            reader.expect(' ');
            float zOffset = reader.readFloat();
            Integer entityID = null;
            if (reader.canRead() && reader.peek() == ' ') {
                reader.expect(' ');
                entityID = reader.readInt();
            }
            return new FlatParticleData(type, radius, rotX, rotY, rotZ, xOffset, yOffset, zOffset, entityID);
        }

        @NotNull
        public FlatParticleData<?> fromNetwork(@NotNull ParticleType<FlatParticleData<?>> type, FriendlyByteBuf buf) {
            float radius = buf.readFloat();
            float rotX = buf.readFloat();
            float rotY = buf.readFloat();
            float rotZ = buf.readFloat();
            float xOffset = buf.readFloat();
            float yOffset = buf.readFloat();
            float zOffset = buf.readFloat();
            Integer entityID = null;
            if (buf.readBoolean()) {
                entityID = buf.readInt();
            }
            return new FlatParticleData(type, radius, rotX, rotY, rotZ, xOffset, yOffset, zOffset, entityID);
        }
    };

    public FlatParticleData(ParticleType<T> type, float radius, float rotX, float rotY, float rotZ, float xOffset, float yOffset, float zOffset, Integer entityID) {
        this.type = type;
        this.radius = radius;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.entityID = entityID;
    }

    public FlatParticleData(ParticleType<T> type, float radius, float rotX, float rotY, float rotZ) {
        this(type, radius, rotX, rotY, rotZ, 0.0f, 0.0f, 0.0f, null);
    }

    public FlatParticleData(ParticleType<T> type, float radius) {
        this(type, radius, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, null);
    }

    public float radius() {
        return this.radius;
    }

    public float rotX() {
        return this.rotX;
    }

    public float rotY() {
        return this.rotY;
    }

    public float rotZ() {
        return this.rotZ;
    }

    public float xOffset() {
        return this.xOffset;
    }

    public float yOffset() {
        return this.yOffset;
    }

    public float zOffset() {
        return this.zOffset;
    }

    public Integer entityID() {
        return this.entityID;
    }

    @NotNull
    public ParticleType<T> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.radius);
        buf.writeFloat(this.rotX);
        buf.writeFloat(this.rotY);
        buf.writeFloat(this.rotZ);
        buf.writeFloat(this.xOffset);
        buf.writeFloat(this.yOffset);
        buf.writeFloat(this.zOffset);
        buf.writeBoolean(this.entityID != null);
        if (this.entityID != null) {
            buf.writeInt(this.entityID.intValue());
        }
    }

    @NotNull
    public String m_5942_() {
        if (this.entityID != null) {
            return String.format("%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.radius), Float.valueOf(this.rotX), Float.valueOf(this.rotY), Float.valueOf(this.rotZ), Float.valueOf(this.xOffset), Float.valueOf(this.yOffset), Float.valueOf(this.zOffset), this.entityID);
        }
        return String.format("%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f ", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.radius), Float.valueOf(this.rotX), Float.valueOf(this.rotY), Float.valueOf(this.rotZ), Float.valueOf(this.xOffset), Float.valueOf(this.yOffset), Float.valueOf(this.zOffset));
    }

    public static class FlatParticleProvider
    implements ParticleProvider<FlatParticleData<?>> {
        private final SpriteSet sprites;

        public FlatParticleProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull FlatParticleData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlatParticle(level, x, y, z, data, this.sprites);
        }
    }
}

