/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.particle.providers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.goo.brutality.particle.base.PointToPointParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PointToPointParticleData<T extends ParticleOptions>
implements ParticleOptions {
    public static final Codec<PointToPointParticleData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.PARTICLE_TYPES.getCodec().fieldOf("type").forGetter(data -> data.type), (App)Codec.FLOAT.fieldOf("x0").forGetter(data -> Float.valueOf(data.x0)), (App)Codec.FLOAT.fieldOf("y0").forGetter(data -> Float.valueOf(data.y0)), (App)Codec.FLOAT.fieldOf("z0").forGetter(data -> Float.valueOf(data.z0)), (App)Codec.FLOAT.fieldOf("x1").forGetter(data -> Float.valueOf(data.x1)), (App)Codec.FLOAT.fieldOf("y1").forGetter(data -> Float.valueOf(data.y1)), (App)Codec.FLOAT.fieldOf("z1").forGetter(data -> Float.valueOf(data.z1))).apply((Applicative)instance, (type, x0, y0, z0, x1, y1, z1) -> new PointToPointParticleData(type, x0.floatValue(), y0.floatValue(), z0.floatValue(), x1.floatValue(), y1.floatValue(), z1.floatValue())));
    protected final ParticleType<T> type;
    protected final float x0;
    protected final float y0;
    protected final float z0;
    protected final float x1;
    protected final float y1;
    protected final float z1;
    public static final ParticleOptions.Deserializer<PointToPointParticleData<?>> DESERIALIZER = new ParticleOptions.Deserializer<PointToPointParticleData<?>>(){

        @NotNull
        public PointToPointParticleData<?> fromCommand(@NotNull ParticleType<PointToPointParticleData<?>> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float x0 = reader.readFloat();
            reader.expect(' ');
            float y0 = reader.readFloat();
            reader.expect(' ');
            float z0 = reader.readFloat();
            reader.expect(' ');
            float x1 = reader.readFloat();
            reader.expect(' ');
            float y1 = reader.readFloat();
            reader.expect(' ');
            float z1 = reader.readFloat();
            return new PointToPointParticleData(type, x0, y0, z0, x1, y1, z1);
        }

        @NotNull
        public PointToPointParticleData<?> fromNetwork(@NotNull ParticleType<PointToPointParticleData<?>> type, FriendlyByteBuf buf) {
            float x0 = buf.readFloat();
            float y0 = buf.readFloat();
            float z0 = buf.readFloat();
            float x1 = buf.readFloat();
            float y1 = buf.readFloat();
            float z1 = buf.readFloat();
            return new PointToPointParticleData(type, x0, y0, z0, x1, y1, z1);
        }
    };

    public PointToPointParticleData(ParticleType<T> type, float x0, float y0, float z0, float x1, float y1, float z1) {
        this.type = type;
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
    }

    public float x0() {
        return this.x0;
    }

    public float y0() {
        return this.y0;
    }

    public float z0() {
        return this.z0;
    }

    public float x1() {
        return this.x1;
    }

    public float y1() {
        return this.y1;
    }

    public float z1() {
        return this.z1;
    }

    @NotNull
    public ParticleType<T> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.x0);
        buf.writeFloat(this.y0);
        buf.writeFloat(this.z0);
        buf.writeFloat(this.x1);
        buf.writeFloat(this.y1);
        buf.writeFloat(this.z1);
    }

    @NotNull
    public String m_5942_() {
        return String.format("%s %.2f %.2f %.2f %.2f %.2f %.2f ", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.x0), Float.valueOf(this.y0), Float.valueOf(this.z0), Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.z1));
    }

    public static class PointToPointParticleProvider
    implements ParticleProvider<PointToPointParticleData<?>> {
        private final SpriteSet sprites;

        public PointToPointParticleProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull PointToPointParticleData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PointToPointParticle(level, x, y, z, data, this.sprites);
        }
    }
}

