/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.particle.providers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.goo.brutality.particle.base.WaveParticle;
import net.goo.brutality.particle.providers.FlatParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WaveParticleData<T extends ParticleOptions>
extends FlatParticleData<T> {
    public static final Codec<WaveParticleData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.PARTICLE_TYPES.getCodec().fieldOf("type").forGetter(data -> data.type), (App)Codec.FLOAT.fieldOf("radius").forGetter(data -> Float.valueOf(data.radius)), (App)Codec.INT.fieldOf("growthDuration").forGetter(data -> data.growthDuration)).apply((Applicative)instance, WaveParticleData::new));
    private final int growthDuration;
    public static final ParticleOptions.Deserializer<WaveParticleData<?>> DESERIALIZER = new ParticleOptions.Deserializer<WaveParticleData<?>>(){

        @NotNull
        public WaveParticleData<?> fromCommand(ParticleType<WaveParticleData<?>> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float radius = reader.readFloat();
            reader.expect(' ');
            int duration = reader.readInt();
            return new WaveParticleData(type, radius, duration);
        }

        @NotNull
        public WaveParticleData<?> fromNetwork(@NotNull ParticleType<WaveParticleData<?>> type, FriendlyByteBuf buf) {
            return new WaveParticleData(type, buf.readFloat(), buf.readInt());
        }
    };

    public WaveParticleData(ParticleType<T> type, float radius, int growthDuration) {
        super(type, radius, 0.0f, 0.0f, 0.0f);
        this.growthDuration = growthDuration;
    }

    public int growthDuration() {
        return this.growthDuration;
    }

    @Override
    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.radius);
        buf.writeInt(this.growthDuration);
    }

    @Override
    @NotNull
    public String m_5942_() {
        return String.format("%s %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.radius), this.growthDuration);
    }

    public static class WaveParticleProvider
    implements ParticleProvider<WaveParticleData<?>> {
        private final SpriteSet sprites;

        public WaveParticleProvider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(@NotNull WaveParticleData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            WaveParticle particle = new WaveParticle(level, x, y, z, data, this.sprites);
            particle.m_108335_(this.sprites);
            return particle;
        }
    }
}

