/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util;

import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.item.base.BrutalityHammerItem;
import net.goo.brutality.item.base.BrutalityScytheItem;
import net.goo.brutality.item.base.BrutalitySpearItem;
import net.goo.brutality.item.base.BrutalityTridentItem;
import net.goo.brutality.particle.providers.WaveParticleData;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.phys.CircleAABB;
import net.mcreator.terramity.init.TerramityModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ModUtils {
    protected static final RandomSource random = RandomSource.m_216327_();

    public static float getAttackDamage(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return (float)livingEntity.m_21133_(Attributes.f_22281_);
        }
        return 1.0f;
    }

    public static Level.ExplosionInteraction getThrowingWeaponExplosionInteractionFromConfig() {
        return (Boolean)BrutalityCommonConfig.THROWING_WEAPONS_BREAK_BLOCKS.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE;
    }

    public static Explosion.BlockInteraction getThrowingWeaponBlockInteractionFromConfig() {
        return (Boolean)BrutalityCommonConfig.THROWING_WEAPONS_BREAK_BLOCKS.get() != false ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.KEEP;
    }

    public static void handleActiveAbilityWithCd(ICuriosItemHandler handler, Item item, int cooldownTicks, Runnable runnable) {
        Player wearer;
        LivingEntity livingEntity;
        if (handler.isEquipped(item) && (livingEntity = handler.getWearer()) instanceof Player && !(wearer = (Player)livingEntity).m_36335_().m_41519_(item)) {
            runnable.run();
            wearer.m_36335_().m_41524_(item, cooldownTicks);
        }
    }

    public static void handleActiveAbility(ICuriosItemHandler handler, Item item, Runnable runnable) {
        if (handler.isEquipped(item)) {
            runnable.run();
        }
    }

    public static Random getSyncedSeededRandom(Entity player) {
        long seed = player.m_9236_().m_46467_();
        seed = seed * 31L + (long)player.m_20148_().hashCode();
        seed = seed * 31L + (long)(player.m_20185_() * 1000.0);
        seed = seed * 31L + (long)(player.m_20186_() * 1000.0);
        seed = seed * 31L + (long)(player.m_20189_() * 1000.0);
        seed = seed * 31L + (long)player.f_19797_;
        return new Random(seed);
    }

    public static double computeAttributes(@Nullable Player player, ItemStack stack, double originalDamage) {
        if (player == null) {
            return originalDamage;
        }
        Map<Predicate<ItemStack>, List<Attribute>> attributeMap = Map.of(s -> s.m_41720_() instanceof SwordItem || s.m_204117_(ItemTags.f_271388_), List.of((Attribute)ModAttributes.SWORD_DAMAGE.get(), (Attribute)ModAttributes.SLASH_DAMAGE.get()), s -> s.m_41720_() instanceof AxeItem || s.m_204117_(ItemTags.f_271207_), List.of((Attribute)ModAttributes.AXE_DAMAGE.get(), (Attribute)ModAttributes.SLASH_DAMAGE.get()), s -> s.m_41720_() instanceof BrutalityHammerItem || s.m_150930_((Item)TerramityModItems.HELLROK_GIGATON_HAMMER.get()), List.of((Attribute)ModAttributes.HAMMER_DAMAGE.get(), (Attribute)ModAttributes.BLUNT_DAMAGE.get()), s -> s.m_41720_() instanceof BrutalityScytheItem, List.of((Attribute)ModAttributes.SCYTHE_DAMAGE.get(), (Attribute)ModAttributes.SLASH_DAMAGE.get()), s -> s.m_41720_() instanceof BrutalitySpearItem || s.m_41720_() instanceof BrutalityTridentItem || s.m_41720_() instanceof TridentItem, List.of((Attribute)ModAttributes.SPEAR_DAMAGE.get(), (Attribute)ModAttributes.PIERCING_DAMAGE.get()), s -> !s.m_150930_((Item)TerramityModItems.HELLROK_GIGATON_HAMMER.get()) && (s.m_41720_() instanceof PickaxeItem || s.m_204117_(ItemTags.f_271360_) || s.m_41720_() instanceof HoeItem || s.m_204117_(ItemTags.f_271298_)), List.of((Attribute)ModAttributes.PIERCING_DAMAGE.get()), s -> s.m_41720_() instanceof ShovelItem || s.m_204117_(ItemTags.f_271138_), List.of((Attribute)ModAttributes.BLUNT_DAMAGE.get()));
        for (Map.Entry<Predicate<ItemStack>, List<Attribute>> entry : attributeMap.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            for (Attribute attribute : entry.getValue()) {
                AttributeInstance attributeInstance = player.m_21051_(attribute);
                if (attributeInstance == null) continue;
                originalDamage = ModUtils.calculateValue(attributeInstance, originalDamage);
            }
        }
        return originalDamage;
    }

    private static double calculateValue(AttributeInstance attributeInstance, double baseValue) {
        for (AttributeModifier additionMultiplier : attributeInstance.m_22116_(AttributeModifier.Operation.ADDITION)) {
            baseValue += additionMultiplier.m_22218_();
        }
        double finalValue = baseValue;
        for (AttributeModifier multiplyBaseModifier : attributeInstance.m_22116_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            finalValue += baseValue * multiplyBaseModifier.m_22218_();
        }
        for (AttributeModifier multiplyTotalModifier : attributeInstance.m_22116_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            finalValue *= 1.0 + multiplyTotalModifier.m_22218_();
        }
        return attributeInstance.m_22099_().m_6740_(finalValue);
    }

    private static BrutalityCategories.AttackType getAttackType(Item item, ItemStack stack) {
        if (item == null || stack == null) {
            return BrutalityCategories.AttackType.NONE;
        }
        if (item instanceof BrutalityGeoItem) {
            BrutalityGeoItem geoItem = (BrutalityGeoItem)item;
            return geoItem.getAttackType();
        }
        if (item instanceof SwordItem || stack.m_204117_(ItemTags.f_271388_)) {
            return BrutalityCategories.AttackType.SLASH;
        }
        if (item instanceof AxeItem || stack.m_204117_(ItemTags.f_271207_)) {
            return BrutalityCategories.AttackType.SLASH;
        }
        return BrutalityCategories.AttackType.NONE;
    }

    public static int calculateFallDamage(LivingEntity living, float pFallDistance, float pDamageMultiplier) {
        if (living.m_6095_().m_204039_(EntityTypeTags.f_273841_)) {
            return 0;
        }
        MobEffectInstance mobeffectinstance = living.m_21124_(MobEffects.f_19603_);
        float f = mobeffectinstance == null ? 0.0f : (float)(mobeffectinstance.m_19564_() + 1);
        return Mth.m_14167_((float)((pFallDistance - 3.0f - f) * pDamageMultiplier));
    }

    public static void removeFX(Entity entity, FX fx) {
        List effects = (List)EntityEffect.CACHE.get(entity);
        if (effects == null) {
            return;
        }
        boolean hasEffect = effects.stream().anyMatch(effect -> effect.getFx().equals(fx));
        if (!hasEffect) {
            return;
        }
        Iterator iter = effects.iterator();
        while (iter.hasNext()) {
            EntityEffect nextEffect = (EntityEffect)iter.next();
            FX nextFX = nextEffect.getFx();
            if (nextFX == null || !nextFX.equals(fx)) continue;
            iter.remove();
            FXRuntime runtime = nextEffect.getRuntime();
            if (runtime == null || !runtime.isAlive()) continue;
            runtime.destroy(false);
        }
        if (effects.isEmpty()) {
            EntityEffect.CACHE.remove(entity);
        }
    }

    public static List<? extends Entity> getEntitiesInSphere(Entity origin, @Nullable Predicate<? super Entity> predicate, double radius) {
        List aabbEntities = predicate == null ? origin.m_9236_().m_45933_(origin, origin.m_20191_().m_82400_(radius)) : origin.m_9236_().m_6249_(origin, origin.m_20191_().m_82400_(radius), predicate);
        return aabbEntities.stream().filter(entity -> (double)entity.m_20270_(origin) < radius).toList();
    }

    public static <T extends Entity> List<T> getEntitiesInSphere(Class<T> clazz, Entity origin, Predicate<? super Entity> predicate, double radius) {
        List aabbEntities = predicate == null ? origin.m_9236_().m_45976_(clazz, origin.m_20191_().m_82400_(radius)) : origin.m_9236_().m_6443_(clazz, origin.m_20191_().m_82400_(radius), predicate);
        return aabbEntities.stream().filter(entity -> (double)entity.m_20270_(origin) < radius && entity != origin).toList();
    }

    public static <T extends Entity> List<T> getEntitiesInCylinder(Class<T> clazz, Entity origin, Predicate<? super Entity> predicate, double radius, double height) {
        AABB aabb = new AABB(origin.m_20185_() - radius, origin.m_20186_(), origin.m_20189_() - radius, origin.m_20185_() + radius, origin.m_20186_() + height, origin.m_20189_() + radius);
        List aabbEntities = predicate == null ? origin.m_9236_().m_45976_(clazz, aabb) : origin.m_9236_().m_6443_(clazz, aabb, predicate);
        return aabbEntities.stream().filter(entity -> (double)ModUtils.horizontalDistanceTo(entity, origin) < radius && entity != origin).toList();
    }

    public static float horizontalDistanceTo(Entity first, Entity second) {
        float x = (float)(first.m_20185_() - second.m_20185_());
        float z = (float)(first.m_20189_() - second.m_20189_());
        return Mth.m_14116_((float)(x * x + z * z));
    }

    public static <T extends ParticleOptions> int sendParticles(ServerLevel serverLevel, T pType, boolean longDistance, double pPosX, double pPosY, double pPosZ, int pParticleCount, double pXOffset, double pYOffset, double pZOffset, double pSpeed) {
        ClientboundLevelParticlesPacket clientboundlevelparticlespacket = new ClientboundLevelParticlesPacket(pType, longDistance, pPosX, pPosY, pPosZ, (float)pXOffset, (float)pYOffset, (float)pZOffset, (float)pSpeed, pParticleCount);
        int i = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!ModUtils.sendParticles(serverLevel, serverPlayer, longDistance, pPosX, pPosY, pPosZ, clientboundlevelparticlespacket)) continue;
            ++i;
        }
        return i;
    }

    public static <T extends ParticleOptions> int sendParticles(ServerLevel serverLevel, T pType, boolean longDistance, Entity toSpawnOn, double pXOffset, double pYOffset, double pZOffset, int pParticleCount, double pSpeed) {
        return ModUtils.sendParticles(serverLevel, pType, longDistance, toSpawnOn.m_20185_(), toSpawnOn.m_20227_(0.5), toSpawnOn.m_20189_(), pParticleCount, pXOffset, pYOffset, pZOffset, pSpeed);
    }

    public static <T extends ParticleOptions> int sendParticles(ServerLevel serverLevel, T pType, boolean longDistance, Vec3 spawnPos, double pXOffset, double pYOffset, double pZOffset, int pParticleCount, double pSpeed) {
        return ModUtils.sendParticles(serverLevel, pType, longDistance, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, pParticleCount, pXOffset, pYOffset, pZOffset, pSpeed);
    }

    public static <T extends ParticleOptions> int sendParticles(ServerLevel serverLevel, T pType, boolean longDistance, double pPosX, double pPosY, double pPosZ, int pParticleCount, double pSpeed) {
        return ModUtils.sendParticles(serverLevel, pType, longDistance, pPosX, pPosY, pPosZ, pParticleCount, 0.0, 0.0, 0.0, pSpeed);
    }

    private static boolean sendParticles(ServerLevel serverLevel, ServerPlayer pPlayer, boolean pLongDistance, double pPosX, double pPosY, double pPosZ, Packet<?> pPacket) {
        if (pPlayer.m_9236_() != serverLevel) {
            return false;
        }
        BlockPos blockpos = pPlayer.m_20183_();
        if (blockpos.m_203195_((Position)new Vec3(pPosX, pPosY, pPosZ), pLongDistance ? 512.0 : 32.0)) {
            pPlayer.f_8906_.m_9829_(pPacket);
            return true;
        }
        return false;
    }

    public static <T extends Entity> List<T> applyWaveEffect(ServerLevel level, Vec3 origin, Class<T> clazz, WaveParticleData<?> particleData, @Nullable Predicate<? super T> filter, Consumer<Entity> effect) {
        return ModUtils.applyWaveEffect(level, origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), clazz, particleData, filter, effect);
    }

    public static <T extends Entity> List<T> applyWaveEffect(ServerLevel level, Entity origin, Class<T> clazz, WaveParticleData<?> particleData, @Nullable Predicate<? super T> filter, Consumer<Entity> effect) {
        return ModUtils.applyWaveEffect(level, origin.m_20185_(), origin.m_20227_(0.5), origin.m_20189_(), clazz, particleData, filter, effect);
    }

    public static <T extends Entity> List<T> applyWaveEffect(ServerLevel level, double x, double y, double z, Class<T> clazz, WaveParticleData<?> particleData, @Nullable Predicate<? super T> filter, Consumer<Entity> effect) {
        float maxRadius = particleData.radius();
        int lifetime = particleData.growthDuration();
        HashSet affectedEntities = new HashSet();
        int ticksPerCheck = 1;
        Vec3 center = new Vec3(x, y, z);
        for (int age = 0; age <= lifetime; age += ticksPerCheck) {
            float growthProgress = (float)age / (float)lifetime;
            growthProgress = Mth.m_14036_((float)growthProgress, (float)0.0f, (float)1.0f);
            float currentRadius = maxRadius * ModEasings.easeOut(growthProgress);
            float previousGrowthProgress = (float)(age - 1) / (float)lifetime;
            previousGrowthProgress = Mth.m_14036_((float)previousGrowthProgress, (float)0.0f, (float)1.0f);
            float previousRadius = maxRadius * ModEasings.easeOut(previousGrowthProgress);
            DelayedTaskScheduler.queueServerWork((Level)level, age, () -> {
                CircleAABB circle = new CircleAABB(center, currentRadius, previousRadius);
                List entities = level.m_6443_(clazz, (AABB)circle, entity -> (filter == null || filter.test(entity)) && circle.m_82390_(entity.m_20182_()));
                for (Entity entity2 : entities) {
                    if (!affectedEntities.add(entity2) || !entity2.m_6084_()) continue;
                    effect.accept(entity2);
                }
            });
        }
        return new ArrayList(affectedEntities);
    }

    public static <T extends Entity> RayData<T> getEntitiesInRay(Class<T> entityClass, LivingEntity origin, float maxRange, ClipContext.Fluid fluidContext, ClipContext.Block blockContext, float beamRadius, @Nullable Predicate<? super T> filter, @NotNull Integer pierceCap, @Nullable Consumer<Vec3> segmentConsumer) {
        Vec3 startPos = origin.m_146892_();
        Vec3 endPos = startPos.m_82549_(origin.m_20154_().m_82490_((double)maxRange));
        Level level = origin.m_9236_();
        BlockHitResult blockResult = level.m_45547_(new ClipContext(startPos, endPos, blockContext, fluidContext, (Entity)origin));
        int distance = (int)startPos.m_82554_(blockResult.m_82425_().m_252807_());
        List<T> targets = ModUtils.collectEntitiesAlongRay(entityClass, origin, startPos, distance, beamRadius, filter, pierceCap, segmentConsumer);
        return new RayData(targets.stream().distinct().collect(Collectors.toList()), distance, blockResult.m_82450_());
    }

    private static <T extends Entity> List<T> collectEntitiesAlongRay(Class<T> entityClass, LivingEntity livingEntity, Vec3 startPos, int distance, float beamRadius, @Nullable Predicate<? super T> filter, Integer pierceCap, @Nullable Consumer<Vec3> segmentConsumer) {
        ArrayList targets = new ArrayList();
        Vec3 lookAngle = livingEntity.m_20154_();
        Level level = livingEntity.m_9236_();
        if (filter != null) {
            for (float dist = 0.0f; dist < (float)distance; dist += beamRadius * 2.0f) {
                Vec3 segmentCenter = startPos.m_82549_(lookAngle.m_82490_((double)dist));
                AABB segmentBox = new AABB(segmentCenter, segmentCenter).m_82400_((double)beamRadius);
                if (segmentConsumer != null) {
                    segmentConsumer.accept(segmentCenter);
                }
                targets.addAll(level.m_6443_(entityClass, segmentBox, filter));
                if (targets.size() <= pierceCap) {
                    continue;
                }
                break;
            }
        } else {
            for (float dist = 0.0f; dist < (float)distance; dist += beamRadius * 2.0f) {
                Vec3 segmentCenter = startPos.m_82549_(lookAngle.m_82490_((double)dist));
                AABB segmentBox = new AABB(segmentCenter, segmentCenter).m_82400_((double)beamRadius);
                targets.addAll(level.m_45976_(entityClass, segmentBox));
                if (targets.size() <= pierceCap) {
                    continue;
                }
                break;
            }
        }
        return targets;
    }

    public static SimpleParticleType getRandomParticle(List<RegistryObject<SimpleParticleType>> particleType) {
        return (SimpleParticleType)particleType.get(random.m_188503_(particleType.size())).get();
    }

    public static SoundEvent getRandomSound(List<RegistryObject<SoundEvent>> soundEvent) {
        return (SoundEvent)soundEvent.get(random.m_188503_(soundEvent.size())).get();
    }

    public static SoundEvent getRandomSound(SoundEvent ... soundEvent) {
        return soundEvent[random.m_188503_(soundEvent.length)];
    }

    public static boolean isPlayerBehind(Player player, Entity entity, int range) {
        Vec3 playerPos = player.m_20318_(1.0f);
        Vec3 entityPos = entity.m_20318_(1.0f);
        Vec3 targetVec = entityPos.m_82546_(playerPos);
        float targetDeg = (float)Math.toDegrees(Math.atan2(targetVec.f_82479_, targetVec.f_82481_)) + 180.0f;
        return targetDeg > (float)(90 - range) && targetDeg < (float)(270 + range);
    }

    public static boolean hasFullArmorSet(LivingEntity livingEntity, ArmorMaterial material) {
        for (ItemStack stack : livingEntity.m_6168_()) {
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem)) {
                return false;
            }
            ArmorItem armorItem = (ArmorItem)item;
            if (armorItem.m_40401_() == material) continue;
            return false;
        }
        return true;
    }

    public static void setTextureIdx(ItemStack stack, int data) {
        stack.m_41784_().m_128405_("texture", data);
    }

    public static void removeTextureIdx(ItemStack stack) {
        stack.m_41784_().m_128473_("texture");
    }

    public static int getTextureIdx(ItemStack stack) {
        return stack.m_41784_().m_128451_("texture");
    }

    public static void modifyEffect(LivingEntity livingEntity, MobEffect mobEffect, @Nullable ModValue durationMod, @Nullable ModValue amplifierMod, Integer limit, @Nullable Consumer<LivingEntity> ifAbsent, @Nullable Consumer<LivingEntity> ifLimit) {
        if (livingEntity.m_21023_(mobEffect)) {
            MobEffectInstance original = livingEntity.m_21124_(mobEffect);
            if (original.m_19564_() >= limit && ifLimit != null) {
                ifLimit.accept(livingEntity);
            }
            int newDuration = original.m_19557_();
            int newAmplifier = original.m_19564_();
            if (durationMod != null) {
                newDuration = durationMod.overwrite() ? durationMod.value : (newDuration += durationMod.value.intValue());
            }
            if (amplifierMod != null) {
                newAmplifier = amplifierMod.overwrite() ? amplifierMod.value : (newAmplifier += amplifierMod.value.intValue());
            }
            livingEntity.m_7292_(new MobEffectInstance(mobEffect, newDuration, newAmplifier, original.m_19571_(), original.m_19572_(), original.m_19575_()));
        } else if (ifAbsent != null) {
            ifAbsent.accept(livingEntity);
        }
    }

    public static BlockPos getBlockLookingAt(Player player, boolean isFluid, float hitDistance) {
        HitResult block = player.m_19907_((double)hitDistance, 1.0f, isFluid);
        if (block.m_6662_() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)block).m_82425_();
        }
        return null;
    }

    public static Vec3 getRandomPosAroundPlayer(Player player, float scale) {
        double randomX = player.m_20208_((double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-scale), (float)scale));
        double randomY = player.m_20187_() * (double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-scale), (float)scale);
        double randomZ = player.m_20262_((double)Mth.m_216267_((RandomSource)player.m_217043_(), (float)(-scale), (float)scale));
        return new Vec3(randomX, randomY, randomZ);
    }

    public static boolean isStandable(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60812_(level, pos);
        return !shape.m_83281_() && shape.m_83297_(Direction.Axis.Y) >= 0.75;
    }

    public static Entity getEntityPlayerLookingAt(Player pPlayer, double range) {
        Vec3 playerPos = pPlayer.m_20299_(1.0f);
        Vec3 viewVector = pPlayer.m_20252_(1.0f).m_82541_();
        List entities = pPlayer.m_9236_().m_45976_(Entity.class, new AABB(playerPos, playerPos).m_82400_(range));
        Entity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distance;
            Optional clipPoint;
            double dotProduct;
            Vec3 entityPos = new Vec3(entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
            Vec3 directionToEntity = entityPos.m_82546_(playerPos);
            double distanceToEntity = directionToEntity.m_82553_();
            Vec3 endPos = playerPos.m_82549_(viewVector.m_82490_(range));
            if (!(distanceToEntity > 0.0) || !(distanceToEntity <= range) || !((dotProduct = viewVector.m_82526_(directionToEntity = directionToEntity.m_82541_())) > 1.0 - 0.075 / distanceToEntity)) continue;
            ClipContext context = new ClipContext(playerPos, entityPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)pPlayer);
            BlockHitResult blockHit = pPlayer.m_9236_().m_45547_(context);
            if (blockHit.m_6662_() != HitResult.Type.MISS || !(clipPoint = entity.m_20191_().m_82371_(playerPos, endPos)).isPresent() || !((distance = playerPos.m_82554_((Vec3)clipPoint.get())) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = distance;
        }
        return closestEntity;
    }

    public static class ModEasings {
        public static float easeQuadOut(float input) {
            return input * (2.0f - input);
        }

        public static float easeQuadIn(float input) {
            return input * input;
        }

        public static float easeOut(float t) {
            return 1.0f - (1.0f - t) * (1.0f - t);
        }
    }

    public record RayData<T extends Entity>(List<T> entityList, int distance, Vec3 endPos) {
        public RayData(List<T> entityList, int distance, Vec3 endPos) {
            this.entityList = Collections.unmodifiableList(entityList);
            this.distance = distance;
            this.endPos = endPos;
        }
    }

    public record ModValue(Integer value, boolean overwrite) {
    }
}

