/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm;

import com.github.charlyb01.timm.command.CommandRegistry;
import com.github.charlyb01.timm.config.Config;
import com.github.charlyb01.timm.config.ModConfigScreen;
import com.github.charlyb01.timm.music.BiomePlaylist;
import com.github.charlyb01.timm.music.Songs;
import com.github.charlyb01.timm.music.StructurePlaylist;
import com.github.charlyb01.timm.network.NetworkingRegistry;
import com.github.charlyb01.timm.registry.SoundEventRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="timm")
public class Timm {
    public static final String MOD_ID = "timm";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void debugLog(String debugString) {
        LOGGER.info(debugString);
    }

    public Timm(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(ClientModEvents::onClientCommands);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(NetworkingRegistry::register);
        SoundEventRegistry.register(modEventBus);
    }

    @EventBusSubscriber(modid="timm", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (minecraft, screen) -> ModConfigScreen.create(screen));
            event.enqueueWork(() -> {
                BiomePlaylist.init();
                Songs.init();
                StructurePlaylist.init();
            });
        }

        public static void onClientCommands(RegisterClientCommandsEvent event) {
            CommandRegistry.init(event);
        }
    }
}

