/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.mixin;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.config.Config;
import com.github.charlyb01.timm.config.StructureFadeOut;
import com.github.charlyb01.timm.imixin.MusicManagerIMixin;
import com.github.charlyb01.timm.imixin.VolumeSettingIMixin;
import com.github.charlyb01.timm.music.BiomePlaylist;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.RandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicManagerMixin
implements MusicManagerIMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Nullable
    private SoundInstance currentMusic;
    @Shadow
    private int nextSongDelay;
    @Unique
    private ResourceLocation timm$lastBiomeEvent;
    @Unique
    private ResourceLocation timm$structureEvent;
    @Unique
    private ResourceLocation timm$structureEventPlaying;
    @Unique
    private float timm$volume = 1.0f;
    @Unique
    private int timm$switchDelay = 0;

    @Shadow
    public abstract void startPlaying(Music var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.minecraft.level == null || this.minecraft.player == null) {
            return;
        }
        if (this.currentMusic == null) {
            if (this.timm$structureEvent != null) {
                this.timm$playStructureMusic();
            }
            return;
        }
        float delta = 1.0f / (float)((Integer)Config.FADE_DURATION.get() * 20);
        if (this.timm$shouldFadeOut()) {
            this.timm$volume = Math.max(0.0f, this.timm$volume - delta);
            ((VolumeSettingIMixin)this.minecraft.getSoundManager()).timm$setVolume(this.currentMusic, this.timm$volume);
            if (this.timm$volume > 0.0f) {
                return;
            }
            this.minecraft.getSoundManager().stop(this.currentMusic);
            this.timm$volume = 1.0f;
            this.nextSongDelay = (Boolean)Config.RESET_DELAY_ON_BIOME_SWITCH.get() != false ? this.random.nextIntBetweenInclusive(((Integer)Config.MIN_DELAY.get()).intValue(), ((Integer)Config.MAX_DELAY.get()).intValue()) : 10;
            this.currentMusic = null;
            if (this.timm$structureEvent == null) {
                return;
            }
            this.timm$playStructureMusic();
        } else if (this.timm$volume < 1.0f) {
            this.timm$volume = Math.min(1.0f, this.timm$volume + delta);
            ((VolumeSettingIMixin)this.minecraft.getSoundManager()).timm$setVolume(this.currentMusic, this.timm$volume);
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")})
    private void saveCurrentBiome(CallbackInfo ci) {
        this.timm$lastBiomeEvent = BiomePlaylist.CURRENT_BIOME_EVENT;
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")})
    private void resetStructure(Music type, CallbackInfo ci) {
        this.timm$structureEventPlaying = null;
    }

    @Unique
    private boolean timm$biomeSwitch() {
        if (BiomePlaylist.UNDEFINED_BIOME.equals((Object)this.timm$lastBiomeEvent)) {
            return false;
        }
        Optional biomeKey = this.minecraft.level.getBiome(this.minecraft.player.blockPosition()).unwrapKey();
        if (biomeKey.isEmpty()) {
            Timm.debugLog("Biome was not registered: likely a bug!");
            return true;
        }
        ArrayList<ResourceLocation> eventsForCurrentBiome = BiomePlaylist.EVENTS_BY_BIOME.get(((ResourceKey)biomeKey.get()).location());
        if (eventsForCurrentBiome == null) {
            Timm.debugLog("Current biome not registered in playlist: fade out to default");
            return true;
        }
        return !eventsForCurrentBiome.contains(this.timm$lastBiomeEvent);
    }

    @Unique
    boolean timm$shouldFadeOut() {
        if (this.timm$structureEvent != null && !this.timm$structureEvent.equals((Object)this.timm$structureEventPlaying)) {
            return true;
        }
        if (this.timm$structureEventPlaying != null && ((StructureFadeOut)((Object)Config.STRUCTURE_FADE_OUT.get())).equals((Object)StructureFadeOut.NEVER)) {
            return false;
        }
        if (this.timm$biomeSwitch()) {
            return ++this.timm$switchDelay >= (Integer)Config.FADE_DELAY.get() * 20;
        }
        this.timm$switchDelay = 0;
        return false;
    }

    @Unique
    private void timm$playStructureMusic() {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)this.timm$structureEvent.getNamespace(), (String)this.timm$structureEvent.getPath());
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)rl);
        Optional optHolder = BuiltInRegistries.SOUND_EVENT.getHolder(key);
        if (optHolder.isEmpty()) {
            return;
        }
        Music music = new Music((Holder)optHolder.get(), ((Integer)Config.MIN_DELAY.get()).intValue(), ((Integer)Config.MAX_DELAY.get()).intValue(), false);
        this.startPlaying(music);
        this.timm$structureEventPlaying = this.timm$structureEvent;
        this.timm$structureEvent = null;
    }

    @Override
    public void timm$setStructureEventId(ResourceLocation soundId) {
        this.timm$structureEvent = soundId;
    }
}

