/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.mixin;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.music.StructurePlaylist;
import com.github.charlyb01.timm.network.PlayPacket;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Unique
    private ResourceLocation timm$currentSoundId;
    @Unique
    private final int timm$tickCheck;

    @Shadow
    public abstract ServerLevel serverLevel();

    public ServerPlayerMixin(Level level, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(level, pos, yaw, gameProfile);
        this.timm$tickCheck = this.uuid.hashCode() % 20;
    }

    @Inject(method={"doTick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.isCreative()) {
            return;
        }
        if (this.tickCount % 20 != this.timm$tickCheck) {
            return;
        }
        StructureManager structureManager = this.serverLevel().structureManager();
        BlockPos playerPos = this.blockPosition();
        HashMap<SectionPos, Set<Structure>> structuresByPos = ServerPlayerMixin.timm$getStructuresAroundPlayer(playerPos, structureManager);
        block0: for (Map.Entry<SectionPos, Set<Structure>> entry : structuresByPos.entrySet()) {
            for (Structure struct : entry.getValue()) {
                Optional tagKey = struct.biomes().unwrapKey();
                if (tagKey.isEmpty()) continue;
                String structureName = ServerPlayerMixin.timm$getStructureName((TagKey<Biome>)((TagKey)tagKey.get()));
                Integer distance = StructurePlaylist.DISTANCE_FROM_STRUCTURE.get(structureName);
                if (distance == null) {
                    Timm.debugLog("Structure distance was not registered for: " + structureName);
                    continue;
                }
                if (!ServerPlayerMixin.timm$structureContains(entry.getKey(), playerPos, struct, distance, structureManager)) continue;
                ResourceLocation soundId = StructurePlaylist.EVENT_ID_FROM_STRUCTURE.get(structureName);
                if (soundId.equals((Object)this.timm$currentSoundId)) continue block0;
                this.timm$currentSoundId = soundId;
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this), (CustomPacketPayload)new PlayPacket(soundId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                continue block0;
            }
        }
    }

    @Unique
    @NotNull
    private static HashMap<SectionPos, Set<Structure>> timm$getStructuresAroundPlayer(BlockPos playerPos, StructureManager structureManager) {
        HashMap<SectionPos, Set<Structure>> structures = new HashMap<SectionPos, Set<Structure>>();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos pos = playerPos.offset(16 * i, 0, 16 * j);
                structures.put(SectionPos.of((BlockPos)pos), structureManager.getAllStructuresAt(pos).keySet());
            }
        }
        return structures;
    }

    @Unique
    private static boolean timm$structureContains(SectionPos sectionPos, BlockPos playerPos, Structure structure, int expansion, StructureManager structureManager) {
        for (StructureStart start : structureManager.startsForStructure(sectionPos, structure)) {
            for (StructurePiece piece : start.getPieces()) {
                if (!piece.getBoundingBox().inflatedBy(expansion).isInside((Vec3i)playerPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private static String timm$getStructureName(TagKey<Biome> biomeTagKey) {
        String[] id = biomeTagKey.location().getPath().split("/");
        return id[id.length - 1];
    }
}

