/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.music;

import com.github.charlyb01.timm.Timm;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;

public class StructurePlaylist {
    public static HashMap<String, Integer> DISTANCE_FROM_STRUCTURE = new HashMap();
    public static HashMap<String, ResourceLocation> EVENT_ID_FROM_STRUCTURE = new HashMap();

    public static void init() {
        Timm.LOGGER.info("Initializing structure playlists");
        Path path = StructurePlaylist.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String structure = jsonReader.nextName();
                ResourceLocation structureId = Timm.id(structure);
                int distance = 0;
                ArrayList<String> structures = new ArrayList<String>();
                if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String name = jsonReader.nextName();
                        if (name.equals("distance")) {
                            distance = jsonReader.nextInt();
                            continue;
                        }
                        if (!name.equals("structures") || jsonReader.peek() != JsonToken.BEGIN_ARRAY) continue;
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            String musicId = jsonReader.nextString();
                            structures.add(musicId);
                        }
                        jsonReader.endArray();
                    }
                    jsonReader.endObject();
                }
                for (String structureName : structures) {
                    DISTANCE_FROM_STRUCTURE.put(structureName, distance);
                    EVENT_ID_FROM_STRUCTURE.put(structureName, structureId);
                }
            }
            Timm.LOGGER.info("Structure playlists successfully initialized");
        }
        catch (IOException e) {
            Timm.LOGGER.error("Error reading structure playlist file: {}", (Object)e.getMessage());
        }
    }

    private static Path getPath() {
        Path loader = FMLPaths.CONFIGDIR.get();
        Path filePath = loader.resolve("timm").resolve("structure_playlists.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        Timm.debugLog("Player structure_playlists.json not found, using default one");
        Optional container = ModList.get().getModContainerById("timm");
        if (container.isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)container.get();
        Optional<Path> path = Optional.of(mod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets/timm/custom/structure_playlists.json"}));
        if (path.isEmpty()) {
            Timm.LOGGER.error("Could not locate default structure_playlists.json");
            return null;
        }
        filePath = path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default structure_playlists.json does not exist");
            return null;
        }
        return filePath;
    }
}

