/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.registry;

import com.github.charlyb01.timm.Timm;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SoundEventRegistry {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"timm");
    public static final HashMap<ResourceLocation, Holder<SoundEvent>> SOUNDEVENT_BY_ID = new HashMap();
    private static final HashMap<ResourceLocation, Supplier<SoundEvent>> REGISTRY_OBJECTS = new HashMap();

    private static void registerBiomes() {
        SoundEventRegistry.register("badlands");
        SoundEventRegistry.register("bamboo_jungle");
        SoundEventRegistry.register("beach");
        SoundEventRegistry.register("birch_forest");
        SoundEventRegistry.register("cherry_grove");
        SoundEventRegistry.register("cold_ocean");
        SoundEventRegistry.register("dark_forest");
        SoundEventRegistry.register("deep_dark");
        SoundEventRegistry.register("desert");
        SoundEventRegistry.register("dripstone_caves");
        SoundEventRegistry.register("flower_forest");
        SoundEventRegistry.register("forest");
        SoundEventRegistry.register("ice_spikes");
        SoundEventRegistry.register("jungle");
        SoundEventRegistry.register("lush_caves");
        SoundEventRegistry.register("meadow");
        SoundEventRegistry.register("mountains");
        SoundEventRegistry.register("mushroom_fields");
        SoundEventRegistry.register("ocean");
        SoundEventRegistry.register("plains");
        SoundEventRegistry.register("river");
        SoundEventRegistry.register("savanna");
        SoundEventRegistry.register("snow_plains");
        SoundEventRegistry.register("swamp");
        SoundEventRegistry.register("taiga");
        SoundEventRegistry.register("warm_ocean");
        SoundEventRegistry.register("windy_hills");
        SoundEventRegistry.register("basalt_deltas");
        SoundEventRegistry.register("crimson_forest");
        SoundEventRegistry.register("nether_wastes");
        SoundEventRegistry.register("soul_sand_valley");
        SoundEventRegistry.register("end");
    }

    private static void registerStructures() {
        SoundEventRegistry.register("ancient_city");
        SoundEventRegistry.register("bastion_remnant");
        SoundEventRegistry.register("buried_treasure");
        SoundEventRegistry.register("desert_pyramid");
        SoundEventRegistry.register("end_city");
        SoundEventRegistry.register("fortress");
        SoundEventRegistry.register("igloo");
        SoundEventRegistry.register("jungle_pyramid");
        SoundEventRegistry.register("mansion");
        SoundEventRegistry.register("mineshaft");
        SoundEventRegistry.register("monument");
        SoundEventRegistry.register("ocean_ruin");
        SoundEventRegistry.register("pillager_outpost");
        SoundEventRegistry.register("ruined_portal");
        SoundEventRegistry.register("ruined_portal_nether");
        SoundEventRegistry.register("shipwreck");
        SoundEventRegistry.register("stronghold");
        SoundEventRegistry.register("swamp_hut");
        SoundEventRegistry.register("trail_ruins");
        SoundEventRegistry.register("trial_chambers");
        SoundEventRegistry.register("village");
    }

    private static void register(String name) {
        ResourceLocation id = Timm.id(name);
        DeferredHolder reg = SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        REGISTRY_OBJECTS.put(id, (Supplier<SoundEvent>)reg);
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
        eventBus.addListener(SoundEventRegistry::setup);
    }

    private static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (Map.Entry<ResourceLocation, Supplier<SoundEvent>> entry : REGISTRY_OBJECTS.entrySet()) {
                SoundEvent sound = entry.getValue().get();
                ResourceLocation id = entry.getKey();
                Holder.Reference holder = (Holder.Reference)BuiltInRegistries.SOUND_EVENT.getHolder((ResourceKey)BuiltInRegistries.SOUND_EVENT.getResourceKey((Object)sound).orElseThrow()).orElseThrow();
                SOUNDEVENT_BY_ID.put(id, (Holder<SoundEvent>)holder);
            }
        });
    }

    static {
        SoundEventRegistry.register("menu");
        SoundEventRegistry.registerBiomes();
        SoundEventRegistry.registerStructures();
    }
}

