/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.client.music;

import com.github.charlyb01.timm.Timm;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class Songs {
    private static final HashMap<class_2960, class_5250> SONG_TEXT_BY_SONG_ID = new HashMap();

    public static class_5250 getSongText(class_2960 songId) {
        if (songId == null) {
            return null;
        }
        return SONG_TEXT_BY_SONG_ID.getOrDefault(songId, class_2561.method_43470((String)songId.toString()));
    }

    public static void init() {
        Timm.LOGGER.info("Initializing songs");
        Path path = Songs.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String song = jsonReader.nextName();
                class_2960 songId = class_2960.method_60654((String)song);
                String songName = null;
                String songUrl = null;
                if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String name = jsonReader.nextName();
                        if (name.equals("name")) {
                            songName = jsonReader.nextString();
                            continue;
                        }
                        if (!name.equals("link")) continue;
                        songUrl = jsonReader.nextString();
                    }
                    jsonReader.endObject();
                }
                SONG_TEXT_BY_SONG_ID.put(songId, Songs.makeSongText(songId, songName, songUrl));
            }
            Timm.LOGGER.info("Songs successfully initialized");
        }
        catch (IOException e) {
            Timm.LOGGER.error("Error reading songs file: {}", (Object)e.getMessage());
        }
    }

    private static class_5250 makeSongText(class_2960 identifier, String name, String url) {
        class_5250 song = class_2561.method_43470((String)(name == null ? identifier.toString() : name));
        if (url != null) {
            song.method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, url)));
        }
        return song;
    }

    private static Path getPath() {
        FabricLoader loader = FabricLoader.getInstance();
        Path filePath = loader.getConfigDir().resolve("timm").resolve("songs.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        Timm.debugLog("Player songs.json not found, using default one");
        if (loader.getModContainer("timm").isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)loader.getModContainer("timm").get();
        Optional path = mod.findPath("assets/timm/custom/songs.json");
        if (path.isEmpty()) {
            Timm.LOGGER.error("Could not locate default songs.json");
            return null;
        }
        filePath = (Path)path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default songs.json does not exist");
            return null;
        }
        return filePath;
    }
}

