/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.mixin;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.music.StructurePlaylist;
import com.github.charlyb01.timm.network.PlayPayload;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_6862;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private class_2960 currentSoundId;
    @Unique
    private final int tickCheck;

    @Shadow
    public abstract class_3218 method_51469();

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
        this.tickCheck = this.field_6021.hashCode() % 20;
    }

    @Inject(method={"playerTick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.method_7337()) {
            return;
        }
        if (this.field_6012 % 20 != this.tickCheck) {
            return;
        }
        class_5138 structureAccessor = this.method_51469().method_27056();
        class_2338 playerPos = this.method_24515();
        HashMap<class_4076, Set<class_3195>> structuresByPos = ServerPlayerEntityMixin.getStructuresAroundPlayer(playerPos, structureAccessor);
        block0: for (Map.Entry<class_4076, Set<class_3195>> entry : structuresByPos.entrySet()) {
            for (class_3195 struct : entry.getValue()) {
                Optional tagKey = struct.method_41607().method_45925();
                if (tagKey.isEmpty()) continue;
                String structureName = ServerPlayerEntityMixin.getStructureName((class_6862<class_1959>)((class_6862)tagKey.get()));
                Integer distance = StructurePlaylist.DISTANCE_FROM_STRUCTURE.get(structureName);
                if (distance == null) {
                    Timm.debugLog("Structure distance was not registered for: " + structureName);
                    continue;
                }
                if (!ServerPlayerEntityMixin.structureContains(entry.getKey(), playerPos, struct, distance, structureAccessor)) continue;
                class_2960 soundId = StructurePlaylist.EVENT_ID_FROM_STRUCTURE.get(structureName);
                if (soundId == null) {
                    Timm.debugLog("Structure ids were not registered for: " + structureName);
                    continue;
                }
                if (soundId.equals((Object)this.currentSoundId)) continue block0;
                this.currentSoundId = soundId;
                ServerPlayNetworking.send((class_3222)((class_3222)this), (class_8710)new PlayPayload(soundId));
                continue block0;
            }
        }
    }

    @Unique
    @NotNull
    private static HashMap<class_4076, Set<class_3195>> getStructuresAroundPlayer(class_2338 playerPos, class_5138 structureAccessor) {
        HashMap<class_4076, Set<class_3195>> structures = new HashMap<class_4076, Set<class_3195>>();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                class_2338 pos = playerPos.method_10069(16 * i, 0, 16 * j);
                structures.put(class_4076.method_18682((class_2338)pos), structureAccessor.method_41037(pos).keySet());
            }
        }
        return structures;
    }

    @Unique
    private static boolean structureContains(class_4076 chunkPos, class_2338 playerPos, class_3195 structure, int expansion, class_5138 structureAccessor) {
        for (class_3449 structureStart : structureAccessor.method_38853(chunkPos, structure)) {
            for (class_3443 structurePiece : structureStart.method_14963()) {
                if (!structurePiece.method_14935().method_35410(expansion).method_14662((class_2382)playerPos)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private static String getStructureName(class_6862<class_1959> biomeTagKey) {
        String[] id = biomeTagKey.comp_327().method_12832().split("/");
        return id[id.length - 1];
    }
}

