/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.client.mixin;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.client.imixin.MusicTrackerIMixin;
import com.github.charlyb01.timm.client.imixin.VolumeSettingIMixin;
import com.github.charlyb01.timm.client.music.BiomePlaylist;
import com.github.charlyb01.timm.config.ModConfig;
import com.github.charlyb01.timm.config.StructureFadeOut;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1142.class})
public abstract class MusicTrackerMixin
implements MusicTrackerIMixin {
    @Shadow
    @Final
    private class_310 field_5575;
    @Shadow
    @Final
    private class_5819 field_5571;
    @Shadow
    @Nullable
    private class_1113 field_5574;
    @Shadow
    private int field_5572;
    @Unique
    private class_2960 lastBiomeEvent;
    @Unique
    private class_2960 structureEvent;
    @Unique
    private class_2960 structureEventPlaying;
    @Unique
    private float volume = 1.0f;
    @Unique
    private int switchDelay = 0;

    @Shadow
    public abstract void method_4858(class_5195 var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.field_5575.field_1687 == null || this.field_5575.field_1724 == null) {
            return;
        }
        if (this.field_5574 == null) {
            if (this.structureEvent != null) {
                this.playStructureMusic();
            }
            return;
        }
        float delta = 1.0f / (float)(ModConfig.get().general.fadeDuration * 20);
        if (this.shouldFadeOut()) {
            this.volume = Math.max(0.0f, this.volume - delta);
            ((VolumeSettingIMixin)this.field_5575.method_1483()).timm$setVolume(this.field_5574, this.volume);
            if (this.volume > 0.0f) {
                return;
            }
            this.field_5575.method_1483().method_4870(this.field_5574);
            this.volume = 1.0f;
            this.field_5572 = ModConfig.get().general.resetDelayOnBiomeSwitch ? this.field_5571.method_39332(ModConfig.get().general.minDelay, ModConfig.get().general.maxDelay) : 10;
            this.field_5574 = null;
            if (this.structureEvent == null) {
                return;
            }
            this.playStructureMusic();
        } else if (this.volume < 1.0f) {
            this.volume = Math.min(1.0f, this.volume + delta);
            ((VolumeSettingIMixin)this.field_5575.method_1483()).timm$setVolume(this.field_5574, this.volume);
        }
    }

    @Inject(method={"play"}, at={@At(value="HEAD")})
    private void saveCurrentBiome(CallbackInfo ci) {
        this.lastBiomeEvent = BiomePlaylist.CURRENT_BIOME_EVENT;
    }

    @Inject(method={"play"}, at={@At(value="HEAD")})
    private void resetStructure(class_5195 type, CallbackInfo ci) {
        this.structureEventPlaying = null;
    }

    @Unique
    private boolean biomeSwitch() {
        if (BiomePlaylist.UNDEFINED_BIOME.equals((Object)this.lastBiomeEvent)) {
            return false;
        }
        Optional currentBiome = this.field_5575.field_1687.method_23753(this.field_5575.field_1724.method_24515()).method_40230();
        if (currentBiome.isEmpty()) {
            Timm.debugLog("Biome was not registered: likely a bug!");
            return true;
        }
        ArrayList<class_2960> eventsForCurrentBiome = BiomePlaylist.EVENTS_BY_BIOME.get(((class_5321)currentBiome.get()).method_29177());
        if (eventsForCurrentBiome == null) {
            Timm.debugLog("Current biome was not registered in playlist: fade out to default");
            return true;
        }
        return !eventsForCurrentBiome.contains(this.lastBiomeEvent);
    }

    @Unique
    private boolean shouldFadeOut() {
        if (this.structureEvent != null && !this.structureEvent.equals((Object)this.structureEventPlaying)) {
            return true;
        }
        if (this.structureEventPlaying != null && ModConfig.get().general.structureFadeOut.equals((Object)StructureFadeOut.NEVER)) {
            return false;
        }
        if (this.biomeSwitch()) {
            return ++this.switchDelay >= ModConfig.get().general.fadeDelay * 20;
        }
        this.switchDelay = 0;
        return false;
    }

    @Unique
    private void playStructureMusic() {
        class_3414 soundEvent = class_3414.method_47908((class_2960)this.structureEvent);
        class_5195 musicSound = new class_5195(class_7923.field_41172.method_47983((Object)soundEvent), ModConfig.get().general.minDelay, ModConfig.get().general.maxDelay, false);
        this.method_4858(musicSound);
        this.structureEventPlaying = this.structureEvent;
        this.structureEvent = null;
    }

    @Override
    public void timm$setStructureEventId(class_2960 soundId) {
        this.structureEvent = soundId;
    }
}

