/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.client.music;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.client.registry.SoundEventRegistry;
import com.github.charlyb01.timm.config.ModConfig;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5195;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class BiomePlaylist {
    public static final class_2960 UNDEFINED_BIOME;
    public static class_2960 CURRENT_BIOME_EVENT;
    public static final HashMap<class_2960, ArrayList<class_2960>> EVENTS_BY_BIOME;
    private static final class_2960 CREATIVE_ID;
    private static final class_2960 MENU_ID;

    public static class_5195 getMusicSound(class_2960 biomeId, class_5819 random) {
        ArrayList<class_2960> musics = EVENTS_BY_BIOME.get(biomeId);
        if (musics == null || musics.isEmpty()) {
            CURRENT_BIOME_EVENT = UNDEFINED_BIOME;
            return null;
        }
        class_2960 soundEventId = musics.get(random.method_43048(musics.size()));
        class_6880<class_3414> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            CURRENT_BIOME_EVENT = UNDEFINED_BIOME;
            return null;
        }
        CURRENT_BIOME_EVENT = soundEventId;
        return new class_5195(soundEvent, ModConfig.get().general.minDelay * 20, ModConfig.get().general.maxDelay * 20, false);
    }

    public static class_5195 getCreativeMusic(class_5819 random) {
        ArrayList<class_2960> musics = EVENTS_BY_BIOME.get(CREATIVE_ID);
        if (musics == null || musics.isEmpty()) {
            return null;
        }
        class_2960 soundEventId = musics.get(random.method_43048(musics.size()));
        class_6880<class_3414> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            return null;
        }
        return new class_5195(soundEvent, ModConfig.get().general.minDelay * 20, ModConfig.get().general.maxDelay * 20, false);
    }

    public static class_5195 getMenuMusic() {
        ArrayList<class_2960> musics = EVENTS_BY_BIOME.get(MENU_ID);
        if (musics == null || musics.isEmpty()) {
            return null;
        }
        class_2960 soundEventId = musics.getFirst();
        class_6880<class_3414> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            return null;
        }
        return new class_5195(soundEvent, 20, 60, false);
    }

    public static void init() {
        Timm.LOGGER.info("Initializing biome playlists");
        Path path = BiomePlaylist.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String biomeName = jsonReader.nextName();
                class_2960 biomeId = class_2960.method_60654((String)biomeName);
                ArrayList<class_2960> musics = new ArrayList<class_2960>();
                if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        String musicId = jsonReader.nextString();
                        musics.add(class_2960.method_60654((String)musicId));
                    }
                    jsonReader.endArray();
                }
                EVENTS_BY_BIOME.put(biomeId, musics);
            }
            Timm.LOGGER.info("Biome playlists successfully initialized");
        }
        catch (IOException e) {
            Timm.LOGGER.error("Error reading biome playlist file: {}", (Object)e.getMessage());
        }
    }

    private static Path getPath() {
        FabricLoader loader = FabricLoader.getInstance();
        Path filePath = loader.getConfigDir().resolve("timm").resolve("biome_playlists.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        Timm.debugLog("Player biome_playlist.json not found, using default one");
        if (loader.getModContainer("timm").isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)loader.getModContainer("timm").get();
        Optional path = mod.findPath("assets/timm/custom/biome_playlists.json");
        if (path.isEmpty()) {
            Timm.LOGGER.error("Could not locate default biome_playlist.json");
            return null;
        }
        filePath = (Path)path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default biome_playlist.json does not exist");
            return null;
        }
        return filePath;
    }

    static {
        CURRENT_BIOME_EVENT = UNDEFINED_BIOME = Timm.id("undefined_biome");
        EVENTS_BY_BIOME = new HashMap();
        CREATIVE_ID = class_2960.method_60654((String)"creative");
        MENU_ID = class_2960.method_60654((String)"menu");
    }
}

