/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.music;

import com.github.charlyb01.timm.Timm;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;

public class StructurePlaylist {
    public static HashMap<String, Integer> DISTANCE_FROM_STRUCTURE = new HashMap();
    public static HashMap<String, class_2960> EVENT_ID_FROM_STRUCTURE = new HashMap();

    public static void init() {
        Timm.LOGGER.info("Initializing structure playlists");
        Path path = StructurePlaylist.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String structure = jsonReader.nextName();
                class_2960 structureId = Timm.id(structure);
                int distance = 0;
                ArrayList<String> structures = new ArrayList<String>();
                if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String name = jsonReader.nextName();
                        if (name.equals("distance")) {
                            distance = jsonReader.nextInt();
                            continue;
                        }
                        if (!name.equals("structures") || jsonReader.peek() != JsonToken.BEGIN_ARRAY) continue;
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            String musicId = jsonReader.nextString();
                            structures.add(musicId);
                        }
                        jsonReader.endArray();
                    }
                    jsonReader.endObject();
                }
                for (String structureName : structures) {
                    DISTANCE_FROM_STRUCTURE.put(structureName, distance);
                    EVENT_ID_FROM_STRUCTURE.put(structureName, structureId);
                }
            }
            Timm.LOGGER.info("Structure playlists successfully initialized");
        }
        catch (IOException e) {
            Timm.LOGGER.error("Error reading structure playlist file: {}", (Object)e.getMessage());
        }
    }

    private static Path getPath() {
        FabricLoader loader = FabricLoader.getInstance();
        Path filePath = loader.getConfigDir().resolve("timm").resolve("structure_playlists.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        Timm.debugLog("Player structure_playlists.json not found, using default one");
        if (loader.getModContainer("timm").isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)loader.getModContainer("timm").get();
        Optional path = mod.findPath("assets/timm/custom/structure_playlists.json");
        if (path.isEmpty()) {
            Timm.LOGGER.error("Could not locate default structure_playlists.json");
            return null;
        }
        filePath = (Path)path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default structure_playlists.json does not exist");
            return null;
        }
        return filePath;
    }
}

