/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.mixin;

import com.github.charlyb01.timm.music.BiomePlaylist;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    public LocalPlayer f_91074_;

    @Inject(method={"getSituationalMusic"}, at={@At(value="FIELD", target="Lnet/minecraft/sounds/Musics;MENU:Lnet/minecraft/sounds/Music;")}, cancellable=true)
    private void updateMenuMusic(CallbackInfoReturnable<Music> cir) {
        Music music = BiomePlaylist.getMenuMusic();
        if (music != null) {
            cir.setReturnValue((Object)music);
        }
    }

    @Inject(method={"getSituationalMusic"}, at={@At(value="FIELD", target="Lnet/minecraft/sounds/Musics;END:Lnet/minecraft/sounds/Music;")}, cancellable=true)
    private void updateEndMusic(CallbackInfoReturnable<Music> cir) {
        if (this.f_91074_ == null) {
            return;
        }
        Holder biome = this.f_91074_.m_9236_().m_204166_(this.f_91074_.m_20183_());
        Optional biomeKey = biome.m_203543_();
        if (biomeKey.isEmpty()) {
            return;
        }
        Music musicSound = BiomePlaylist.getMusicSound(((ResourceKey)biomeKey.get()).m_135782_(), this.f_91074_.m_217043_());
        if (musicSound != null) {
            cir.setReturnValue((Object)musicSound);
        }
    }

    @Inject(method={"getSituationalMusic"}, at={@At(value="FIELD", target="Lnet/minecraft/sounds/Musics;CREATIVE:Lnet/minecraft/sounds/Music;")}, cancellable=true)
    private void updateCreativeMusic(CallbackInfoReturnable<Music> cir) {
        if (this.f_91074_ == null) {
            return;
        }
        Music musicSound = BiomePlaylist.getCreativeMusic(this.f_91074_.m_217043_());
        if (musicSound != null) {
            cir.setReturnValue((Object)musicSound);
        }
    }

    @Inject(method={"getSituationalMusic"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getBackgroundMusic()Ljava/util/Optional;", shift=At.Shift.AFTER)}, cancellable=true)
    private void updateBiomeMusic(CallbackInfoReturnable<Music> cir) {
        if (this.f_91074_ == null) {
            return;
        }
        Holder biome = this.f_91074_.m_9236_().m_204166_(this.f_91074_.m_20183_());
        Optional biomeKey = biome.m_203543_();
        if (biomeKey.isEmpty()) {
            return;
        }
        Music musicSound = BiomePlaylist.getMusicSound(((ResourceKey)biomeKey.get()).m_135782_(), this.f_91074_.m_217043_());
        if (musicSound != null) {
            cir.setReturnValue((Object)musicSound);
        }
    }
}

