/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.mixin;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.command.NowPlayingCmd;
import com.github.charlyb01.timm.config.Config;
import com.github.charlyb01.timm.config.StructureFadeOut;
import com.github.charlyb01.timm.imixin.MusicManagerIMixin;
import com.github.charlyb01.timm.imixin.VolumeSettingIMixin;
import com.github.charlyb01.timm.music.BiomePlaylist;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.RandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicManagerMixin
implements MusicManagerIMixin {
    @Shadow
    @Final
    private Minecraft f_120178_;
    @Shadow
    @Final
    private RandomSource f_120177_;
    @Shadow
    @Nullable
    private SoundInstance f_120179_;
    @Shadow
    private int f_120180_;
    @Unique
    private ResourceLocation timm$lastBiomeEvent;
    @Unique
    private ResourceLocation timm$structureEvent;
    @Unique
    private ResourceLocation timm$structureEventPlaying;
    @Unique
    private float timm$volume = 1.0f;
    @Unique
    private int timm$switchDelay = 0;

    @Shadow
    public abstract void m_120184_(Music var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.f_120178_.f_91073_ == null || this.f_120178_.f_91074_ == null) {
            return;
        }
        if (this.f_120179_ == null) {
            if (this.timm$structureEvent != null) {
                this.timm$playStructureMusic();
            }
            return;
        }
        float delta = 1.0f / (float)((Integer)Config.FADE_DURATION.get() * 20);
        if (this.timm$shouldFadeOut()) {
            this.timm$volume = Math.max(0.0f, this.timm$volume - delta);
            ((VolumeSettingIMixin)this.f_120178_.m_91106_()).timm$setVolume(this.f_120179_, this.timm$volume);
            if (this.timm$volume > 0.0f) {
                return;
            }
            this.f_120178_.m_91106_().m_120399_(this.f_120179_);
            this.timm$volume = 1.0f;
            this.f_120180_ = (Boolean)Config.RESET_DELAY_ON_BIOME_SWITCH.get() != false ? this.f_120177_.m_216332_(((Integer)Config.MIN_DELAY.get()).intValue(), ((Integer)Config.MAX_DELAY.get()).intValue()) : 10;
            this.f_120179_ = null;
            if (this.timm$structureEvent == null) {
                return;
            }
            this.timm$playStructureMusic();
        } else if (this.timm$volume < 1.0f) {
            this.timm$volume = Math.min(1.0f, this.timm$volume + delta);
            ((VolumeSettingIMixin)this.f_120178_.m_91106_()).timm$setVolume(this.f_120179_, this.timm$volume);
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")})
    private void saveCurrentBiome(CallbackInfo ci) {
        this.timm$lastBiomeEvent = BiomePlaylist.CURRENT_BIOME_EVENT;
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")})
    private void resetStructure(Music type, CallbackInfo ci) {
        this.timm$structureEventPlaying = null;
    }

    @Inject(method={"startPlaying"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V", shift=At.Shift.AFTER)})
    private void saveMusicIdentifier(Music music, CallbackInfo ci) {
        if (this.f_120179_ == null || this.f_120179_.m_5891_() == null) {
            return;
        }
        NowPlayingCmd.SONG_ID = this.f_120179_.m_5891_().m_119787_();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void resetMusicIdentifierOnNull(CallbackInfo ci) {
        if (this.f_120179_ == null) {
            NowPlayingCmd.SONG_ID = null;
        }
    }

    @Unique
    private boolean timm$biomeSwitch() {
        if (BiomePlaylist.UNDEFINED_BIOME.equals((Object)this.timm$lastBiomeEvent)) {
            return false;
        }
        Optional biomeKey = this.f_120178_.f_91073_.m_204166_(this.f_120178_.f_91074_.m_20183_()).m_203543_();
        if (biomeKey.isEmpty()) {
            Timm.debugLog("Biome was not registered: likely a bug!");
            return true;
        }
        ArrayList<ResourceLocation> eventsForCurrentBiome = BiomePlaylist.EVENTS_BY_BIOME.get(((ResourceKey)biomeKey.get()).m_135782_());
        if (eventsForCurrentBiome == null) {
            Timm.debugLog("Current biome not registered in playlist: fade out to default");
            return true;
        }
        return !eventsForCurrentBiome.contains(this.timm$lastBiomeEvent);
    }

    @Unique
    boolean timm$shouldFadeOut() {
        if (this.timm$structureEvent != null && !this.timm$structureEvent.equals((Object)this.timm$structureEventPlaying)) {
            return true;
        }
        if (this.timm$structureEventPlaying != null && ((StructureFadeOut)((Object)Config.STRUCTURE_FADE_OUT.get())).equals((Object)StructureFadeOut.NEVER)) {
            return false;
        }
        if (this.timm$biomeSwitch()) {
            return ++this.timm$switchDelay >= (Integer)Config.FADE_DELAY.get() * 20;
        }
        this.timm$switchDelay = 0;
        return false;
    }

    @Unique
    private void timm$playStructureMusic() {
        ResourceLocation rl = new ResourceLocation(this.timm$structureEvent.m_135827_(), this.timm$structureEvent.m_135815_());
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256840_, (ResourceLocation)rl);
        Optional optHolder = BuiltInRegistries.f_256894_.m_203636_(key);
        if (optHolder.isEmpty()) {
            return;
        }
        Music music = new Music((Holder)optHolder.get(), ((Integer)Config.MIN_DELAY.get()).intValue(), ((Integer)Config.MAX_DELAY.get()).intValue(), false);
        this.m_120184_(music);
        this.timm$structureEventPlaying = this.timm$structureEvent;
        this.timm$structureEvent = null;
    }

    @Override
    public void timm$setStructureEventId(ResourceLocation soundId) {
        this.timm$structureEvent = soundId;
    }

    @Inject(method={"stopPlaying()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;stop(Lnet/minecraft/client/resources/sounds/SoundInstance;)V")})
    private void resetMusicIdentifierOnStop(CallbackInfo ci) {
        NowPlayingCmd.SONG_ID = null;
    }
}

