/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.music;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.config.Config;
import com.github.charlyb01.timm.registry.SoundEventRegistry;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class BiomePlaylist {
    public static final ResourceLocation UNDEFINED_BIOME;
    public static ResourceLocation CURRENT_BIOME_EVENT;
    public static final HashMap<ResourceLocation, ArrayList<ResourceLocation>> EVENTS_BY_BIOME;
    private static final ResourceLocation CREATIVE_ID;
    private static final ResourceLocation MENU_ID;

    public static Music getMusicSound(ResourceLocation biomeId, RandomSource random) {
        ArrayList<ResourceLocation> musics = EVENTS_BY_BIOME.get(biomeId);
        if (musics == null || musics.isEmpty()) {
            CURRENT_BIOME_EVENT = UNDEFINED_BIOME;
            return null;
        }
        ResourceLocation soundEventId = musics.get(random.m_188503_(musics.size()));
        Holder<SoundEvent> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            CURRENT_BIOME_EVENT = UNDEFINED_BIOME;
            return null;
        }
        CURRENT_BIOME_EVENT = soundEventId;
        return new Music(soundEvent, (Integer)Config.MIN_DELAY.get() * 20, (Integer)Config.MAX_DELAY.get() * 20, false);
    }

    public static Music getCreativeMusic(RandomSource random) {
        ArrayList<ResourceLocation> musics = EVENTS_BY_BIOME.get(CREATIVE_ID);
        if (musics == null || musics.isEmpty()) {
            return null;
        }
        ResourceLocation soundEventId = musics.get(random.m_188503_(musics.size()));
        Holder<SoundEvent> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            return null;
        }
        return new Music(soundEvent, (Integer)Config.MIN_DELAY.get() * 20, (Integer)Config.MAX_DELAY.get() * 20, false);
    }

    public static Music getMenuMusic() {
        ArrayList<ResourceLocation> musics = EVENTS_BY_BIOME.get(MENU_ID);
        if (musics == null || musics.isEmpty()) {
            return null;
        }
        ResourceLocation soundEventId = musics.get(0);
        Holder<SoundEvent> soundEvent = SoundEventRegistry.SOUNDEVENT_BY_ID.get(soundEventId);
        if (soundEvent == null) {
            return null;
        }
        return new Music(soundEvent, 20, 60, false);
    }

    public static void init() {
        Timm.LOGGER.info("Initializing biome playlists");
        Path path = BiomePlaylist.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String biomeName = jsonReader.nextName();
                ResourceLocation biomeId = new ResourceLocation(biomeName);
                ArrayList<ResourceLocation> musics = new ArrayList<ResourceLocation>();
                if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        String musicId = jsonReader.nextString();
                        musics.add(new ResourceLocation(musicId));
                    }
                    jsonReader.endArray();
                }
                EVENTS_BY_BIOME.put(biomeId, musics);
            }
            Timm.LOGGER.info("Biome playlists successfully initialized");
        }
        catch (IOException why) {
            Timm.LOGGER.error("Error reading biome playlist file: {}", (Object)why.getMessage());
        }
    }

    private static Path getPath() {
        Path loader = FMLPaths.CONFIGDIR.get();
        Path filePath = loader.resolve("timm").resolve("biome_playlists.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        Timm.debugLog("Player biome playlist.json not found, using default one");
        Optional container = ModList.get().getModContainerById("timm");
        if (container.isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)container.get();
        Optional<Path> path = Optional.of(mod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets/timm/custom/biome_playlists.json"}));
        filePath = path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default biome_playlist.json does not exist");
            return null;
        }
        return filePath;
    }

    static {
        CURRENT_BIOME_EVENT = UNDEFINED_BIOME = Timm.id("undefined_biome");
        EVENTS_BY_BIOME = new HashMap();
        CREATIVE_ID = ResourceLocation.m_135820_((String)"creative");
        MENU_ID = ResourceLocation.m_135820_((String)"menu");
    }
}

