/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.timm.music;

import com.github.charlyb01.timm.Timm;
import com.github.charlyb01.timm.config.Config;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class Songs {
    private static final HashMap<ResourceLocation, MutableComponent> SONG_TEXT_BY_SONG_ID = new HashMap();

    public static MutableComponent getSongText(ResourceLocation songId) {
        if (songId == null) {
            return null;
        }
        return SONG_TEXT_BY_SONG_ID.getOrDefault(songId, Component.m_237113_((String)songId.toString()));
    }

    public static void init() {
        Timm.LOGGER.info("Initializing songs");
        Path path = Songs.getPath();
        if (path == null) {
            return;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(Files.newInputStream(path, new OpenOption[0])));
            while (jsonReader.hasNext()) {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    continue;
                }
                if (jsonToken == JsonToken.END_OBJECT) {
                    jsonReader.endObject();
                    continue;
                }
                String song = jsonReader.nextName();
                ResourceLocation songId = new ResourceLocation(song);
                String songName = null;
                String songUrl = null;
                if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String name = jsonReader.nextName();
                        if (name.equals("name")) {
                            songName = jsonReader.nextString();
                            continue;
                        }
                        if (!name.equals("link")) continue;
                        songUrl = jsonReader.nextString();
                    }
                    jsonReader.endObject();
                }
                SONG_TEXT_BY_SONG_ID.put(songId, Songs.makeSongText(songId, songName, songUrl));
            }
            Timm.LOGGER.info("Songs successfully initialized");
        }
        catch (IOException why) {
            Timm.LOGGER.error("Error reading songs file: {}", (Object)why.getMessage());
        }
    }

    private static MutableComponent makeSongText(ResourceLocation identifier, String name, String url) {
        MutableComponent song = Component.m_237113_((String)(name == null ? identifier.toString() : name));
        if (url != null) {
            song.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        }
        return song;
    }

    private static Path getPath() {
        Optional container;
        Path loader = FMLPaths.CONFIGDIR.get();
        Path filePath = loader.resolve("timm").resolve("songs.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        if (((Boolean)Config.DEBUG_LOG.get()).booleanValue()) {
            Timm.LOGGER.info("Player songs.json not found using default one");
        }
        if ((container = ModList.get().getModContainerById("timm")).isEmpty()) {
            Timm.LOGGER.error("Mod not correctly loaded");
            return null;
        }
        ModContainer mod = (ModContainer)container.get();
        Optional<Path> path = Optional.of(mod.getModInfo().getOwningFile().getFile().findResource(new String[]{"assets/timm/custom/songs.json"}));
        filePath = path.get();
        if (!Files.exists(filePath, new LinkOption[0])) {
            Timm.LOGGER.error("Default songs.json does not exist");
            return null;
        }
        return filePath;
    }
}

