/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.server.ServerLifecycleHooks;

public class events14 {
    private static final Random RANDOM = new Random();
    private static final List<Item> POSSIBLE_BLOCK_ITEMS = Arrays.asList(Blocks.DIRT.asItem(), Blocks.COBBLESTONE.asItem(), Blocks.OAK_LOG.asItem(), Blocks.BIRCH_LOG.asItem(), Blocks.SPRUCE_LOG.asItem(), Blocks.JUNGLE_LOG.asItem(), Blocks.ACACIA_LOG.asItem(), Blocks.DARK_OAK_LOG.asItem(), Blocks.SAND.asItem(), Blocks.GRAVEL.asItem(), Blocks.STONE.asItem(), Blocks.ANDESITE.asItem(), Blocks.DIORITE.asItem(), Blocks.GRANITE.asItem(), Blocks.OAK_PLANKS.asItem(), Blocks.BIRCH_PLANKS.asItem(), Blocks.SPRUCE_PLANKS.asItem(), Blocks.MELON.asItem(), Blocks.PUMPKIN.asItem(), Blocks.CLAY.asItem());
    private static final List<Integer> POSSIBLE_TIMES = Arrays.asList(15, 25, 35, 45);

    public static void trigger(Collection<ServerPlayer> players) {
        if (players == null || players.isEmpty()) {
            return;
        }
        int countNeeded = 1 + RANDOM.nextInt(15);
        Item targetItem = POSSIBLE_BLOCK_ITEMS.get(RANDOM.nextInt(POSSIBLE_BLOCK_ITEMS.size()));
        int timeLimit = POSSIBLE_TIMES.get(RANDOM.nextInt(POSSIBLE_TIMES.size()));
        String itemName = new ItemStack((ItemLike)targetItem).getHoverName().getString();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerPlayer player : players) {
            player.sendSystemMessage((Component)Component.literal((String)("\u0423\u0441\u043f\u0435\u0439\u0442\u0435 \u0434\u043e\u0431\u044b\u0442\u044c " + countNeeded + " " + itemName + " \u0437\u0430 " + timeLimit + " \u0441\u0435\u043a!")));
        }
        Thread timerThread = new Thread(() -> {
            try {
                long endTime = System.currentTimeMillis() + (long)timeLimit * 1000L;
                boolean finishedEarly = false;
                while (System.currentTimeMillis() < endTime && !finishedEarly) {
                    boolean[] allDone = new boolean[]{true};
                    CountDownLatch latch = new CountDownLatch(1);
                    server.execute(() -> {
                        for (ServerPlayer player : players) {
                            int total = 0;
                            for (ItemStack stack : player.getInventory()) {
                                if (stack.isEmpty() || !stack.is(targetItem)) continue;
                                total += stack.getCount();
                            }
                            long remaining = Math.max(0L, (endTime - System.currentTimeMillis()) / 1000L);
                            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.literal((String)("\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: " + remaining + " \u0441\u0435\u043a"))));
                            if (total >= countNeeded) {
                                player.sendSystemMessage((Component)Component.literal((String)"\u0412\u044b \u0443\u0441\u043f\u0435\u043b\u0438 \u0434\u043e\u0431\u044b\u0442\u044c \u043d\u0443\u0436\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u043b\u043e\u043a\u043e\u0432!"));
                                continue;
                            }
                            allDone[0] = false;
                        }
                        latch.countDown();
                    });
                    latch.await(500L, TimeUnit.MILLISECONDS);
                    if (allDone[0]) {
                        finishedEarly = true;
                        break;
                    }
                    Thread.sleep(100L);
                }
                CountDownLatch finalLatch = new CountDownLatch(1);
                server.execute(() -> {
                    for (ServerPlayer player : players) {
                        int total = 0;
                        for (ItemStack stack : player.getInventory()) {
                            if (stack.isEmpty() || !stack.is(targetItem)) continue;
                            total += stack.getCount();
                        }
                        if (total >= countNeeded) continue;
                        player.sendSystemMessage((Component)Component.literal((String)"\u0412\u044b \u043d\u0435 \u0434\u043e\u0431\u044b\u043b\u0438 \u043d\u0443\u0436\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438. \u0421\u043c\u0435\u0440\u0442\u044c."));
                        DamageSource source = player.level().damageSources().fellOutOfWorld();
                        player.hurt(source, Float.MAX_VALUE);
                    }
                    finalLatch.countDown();
                });
                finalLatch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "EndlessEvents-collect-timer-" + System.currentTimeMillis());
        timerThread.start();
    }
}

