/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endlessevents")
public class events17 {
    private static final Random RNG = new Random();
    private static final List<Item> POSSIBLE_ITEMS = List.of(Items.DIRT, Items.COBBLESTONE, Items.OAK_LOG, Items.BIRCH_LOG, Items.SPRUCE_LOG, Items.APPLE, Items.WHEAT, Items.CARROT, Items.POTATO, Items.IRON_INGOT);
    private static final Map<BlockPos, Item> SIGN_MAP = new ConcurrentHashMap<BlockPos, Item>();
    private static final List<EntityType<? extends Mob>> POSSIBLE_MOBS = List.of(EntityType.SKELETON, EntityType.CREEPER, EntityType.ZOMBIE, EntityType.SPIDER);

    public static void trigger(Collection<ServerPlayer> players) {
        if (players == null || players.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            BlockPos pos = player.blockPosition();
            Item targetItem = POSSIBLE_ITEMS.get(RNG.nextInt(POSSIBLE_ITEMS.size()));
            String itemName = new ItemStack((ItemLike)targetItem).getHoverName().getString();
            level.setBlock(pos, Blocks.OAK_SIGN.defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                MutableComponent line0 = Component.literal((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b");
                MutableComponent line1 = Component.literal((String)"\u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442");
                MutableComponent line2 = Component.literal((String)itemName);
                MutableComponent line3 = Component.literal((String)"");
                SignText signText = new SignText(new Component[]{line0, line1, line2, line3}, new Component[]{line0, line1, line2, line3}, DyeColor.BLACK, false);
                sign.setText(signText, true);
                level.sendBlockUpdated(pos, sign.getBlockState(), sign.getBlockState(), 3);
            }
            SIGN_MAP.put(pos, targetItem);
            player.sendSystemMessage((Component)Component.literal((String)("\u041f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0447\u043a\u0430: \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u041f\u041a\u041c, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c " + itemName)));
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                level.getServer().execute(() -> {
                    if (SIGN_MAP.containsKey(pos)) {
                        level.removeBlock(pos, false);
                        SIGN_MAP.remove(pos);
                    }
                });
            }).start();
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        Item mapped = SIGN_MAP.get(pos);
        if (mapped == null) {
            return;
        }
        Player p = event.getEntity();
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)p;
        ServerLevel level = (ServerLevel)serverPlayer.getCommandSenderWorld();
        ItemStack stack = new ItemStack((ItemLike)mapped, 1);
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, stack);
        level.addFreshEntity((Entity)itemEntity);
        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
        serverPlayer.sendSystemMessage((Component)Component.literal((String)("\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438: " + mapped.getName(stack).getString())));
        if (RNG.nextBoolean()) {
            EntityType<? extends Mob> mobType = POSSIBLE_MOBS.get(RNG.nextInt(POSSIBLE_MOBS.size()));
            Zombie mob = null;
            if (mobType == EntityType.ZOMBIE) {
                mob = new Zombie(EntityType.ZOMBIE, (Level)level);
            } else if (mobType == EntityType.SKELETON) {
                mob = new Skeleton(EntityType.SKELETON, (Level)level);
            } else if (mobType == EntityType.CREEPER) {
                mob = new Creeper(EntityType.CREEPER, (Level)level);
            } else if (mobType == EntityType.SPIDER) {
                mob = new Spider(EntityType.SPIDER, (Level)level);
            }
            if (mob != null) {
                mob.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
                mob.setYRot(level.random.nextFloat() * 360.0f);
                mob.setXRot(0.0f);
                level.addFreshEntity((Entity)mob);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }
}

