/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events22 {
    private static final Random RNG = new Random();

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            if (player.level().isClientSide()) continue;
            ServerLevel level = (ServerLevel)player.level();
            BlockPos origin = player.blockPosition().above(150);
            int radius = 5;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        BlockPos pos = origin.offset(x, y, z);
                        if (x == 0 && y == 0 && z == 0) continue;
                        BlockState state = Blocks.STONE.defaultBlockState();
                        FallingBlockEntity falling = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
                        level.addFreshEntity((Entity)falling);
                    }
                }
            }
            BlockPos chestPos = origin;
            level.setBlock(chestPos, Blocks.CHEST.defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity(chestPos);
            if (!(blockEntity instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.setItem(0, Items.DIAMOND.getDefaultInstance());
            chest.setItem(1, Items.EMERALD.getDefaultInstance());
            chest.setItem(2, Items.GOLD_INGOT.getDefaultInstance());
            chest.setChanged();
        }
    }

    @SubscribeEvent
    public static void onFallingBlockLand(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity falling = (FallingBlockEntity)entity;
        Level level = falling.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        level2.getServer().execute(() -> {
            if (!falling.onGround()) {
                return;
            }
            BlockPos center = falling.blockPosition();
            int craterDepth = 3;
            int craterRadius = 5;
            for (int dx = -craterRadius; dx <= craterRadius; ++dx) {
                for (int dz = -craterRadius; dz <= craterRadius; ++dz) {
                    for (int dy = 0; dy > -craterDepth; --dy) {
                        BlockPos pos = center.offset(dx, dy, dz);
                        if (level2.getBlockState(pos).isAir()) continue;
                        level2.removeBlock(pos, false);
                    }
                }
            }
            level2.playSound(null, (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level2.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, 50, 1.0, 1.0, 1.0, 0.0);
        });
    }
}

