/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events24 {
    private static final Map<ServerPlayer, Integer> jumpsRemaining = new HashMap<ServerPlayer, Integer>();
    private static final Map<ServerPlayer, Long> nextJumpTime = new HashMap<ServerPlayer, Long>();
    private static final long JUMP_DELAY = 20L;

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            jumpsRemaining.put(player, 3);
            nextJumpTime.put(player, player.level().getGameTime());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!jumpsRemaining.containsKey(player2)) {
            return;
        }
        long currentTime = player2.level().getGameTime();
        if (currentTime >= nextJumpTime.get(player2)) {
            Vec3 look = player2.getLookAngle().normalize();
            double upward = 1.0;
            double forward = 1.2;
            Vec3 motion = new Vec3(look.x * forward, upward, look.z * forward);
            player2.setDeltaMovement(motion);
            player2.hurtMarked = true;
            int remaining = jumpsRemaining.get(player2) - 1;
            if (remaining <= 0) {
                jumpsRemaining.remove(player2);
                nextJumpTime.remove(player2);
            } else {
                jumpsRemaining.put(player2, remaining);
                nextJumpTime.put(player2, currentTime + 20L);
            }
        }
    }
}

