/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events26 {
    private static final Map<ServerPlayer, Long> activePlayers = new HashMap<ServerPlayer, Long>();

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            long endTime = player.level().getGameTime() + 600L;
            activePlayers.put(player, endTime);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long endTime;
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!activePlayers.containsKey(player2)) {
            return;
        }
        long gameTime = player2.level().getGameTime();
        if (gameTime >= (endTime = activePlayers.get(player2).longValue())) {
            activePlayers.remove(player2);
            return;
        }
        BlockPos below = player2.blockPosition().below();
        if (!player2.level().isLoaded(below)) {
            return;
        }
        if (!player2.level().getBlockState(below).is(Blocks.WATER)) {
            return;
        }
        Vec3 vel = player2.getDeltaMovement();
        double added = 0.12;
        double newY = vel.y + added;
        double maxY = 0.6;
        if (newY > maxY) {
            newY = maxY;
        }
        if (newY <= 0.0) {
            newY = Math.max(0.08, newY + added);
        }
        player2.setDeltaMovement(vel.x, newY, vel.z);
        player2.push(0.0, 0.06, 0.0);
        player2.resetFallDistance();
        player2.setSwimming(false);
        player2.getAbilities().flying = false;
        player2.getAbilities().mayfly = false;
        try {
            player2.hurtMarked = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

