/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events27 {
    private static final long DURATION_TICKS = 1200L;
    private static final Map<UUID, Long> activePlayers = new HashMap<UUID, Long>();

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer sp : players) {
            UUID id = sp.getUUID();
            long endTime = sp.level().getGameTime() + 1200L;
            activePlayers.put(id, endTime);
            Level lvl = sp.level();
            if (!(lvl instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)lvl;
            serverLevel.setDayTime(1000L);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID id = player2.getUUID();
        if (!activePlayers.containsKey(id)) {
            return;
        }
        ItemStack held = player2.getItemInHand(InteractionHand.MAIN_HAND);
        if (held.isEmpty()) {
            return;
        }
        Item item = held.getItem();
        if (item == Items.WOODEN_PICKAXE || item == Items.STONE_PICKAXE || item == Items.IRON_PICKAXE || item == Items.GOLDEN_PICKAXE || item == Items.DIAMOND_PICKAXE || item == Items.NETHERITE_PICKAXE) {
            ServerLevel serverLevel;
            BlockPos pos = event.getPos();
            Level level = player2.level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isLoaded(pos)) {
                serverLevel.destroyBlock(pos, true, (Entity)player2);
                held.hurtAndBreak(2, (LivingEntity)player2, EquipmentSlot.MAINHAND);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID id = player2.getUUID();
        if (!activePlayers.containsKey(id)) {
            return;
        }
        ItemStack main = player2.getItemInHand(InteractionHand.MAIN_HAND);
        if (main.isDamageableItem()) {
            main.hurtAndBreak(1, (LivingEntity)player2, EquipmentSlot.MAINHAND);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer attacker = (ServerPlayer)entity;
            UUID id = attacker.getUUID();
            if (!activePlayers.containsKey(id)) {
                return;
            }
            ItemStack main = attacker.getItemInHand(InteractionHand.MAIN_HAND);
            Item item = main.getItem();
            if (item == Items.WOODEN_SWORD || item == Items.STONE_SWORD || item == Items.IRON_SWORD || item == Items.GOLDEN_SWORD || item == Items.DIAMOND_SWORD || item == Items.NETHERITE_SWORD) {
                event.setAmount(event.getAmount() * 2.0f);
                if (main.isDamageableItem()) {
                    main.hurtAndBreak(1, (LivingEntity)attacker, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long end;
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID id = player2.getUUID();
        if (!activePlayers.containsKey(id)) {
            return;
        }
        long now = player2.level().getGameTime();
        if (now >= (end = activePlayers.get(id).longValue())) {
            activePlayers.remove(id);
        }
    }
}

