/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events28 {
    private static final Map<ServerPlayer, Long> activePlayers = new HashMap<ServerPlayer, Long>();
    private static final Map<ServerPlayer, Long> lastPlay = new HashMap<ServerPlayer, Long>();
    private static final Random random = new Random();
    private static final long INTERVAL = 10L;
    private static final SoundEvent[] SCARY_SOUNDS = new SoundEvent[]{SoundEvents.STONE_BREAK, SoundEvents.STONE_HIT, SoundEvents.WOOD_BREAK, SoundEvents.WOOD_HIT, SoundEvents.SAND_BREAK, SoundEvents.GRASS_STEP, SoundEvents.CAVE_VINES_FALL, SoundEvents.WARDEN_AGITATED};

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            long endTime = player.level().getGameTime() + 1200L;
            activePlayers.put(player, endTime);
            lastPlay.put(player, player.level().getGameTime());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerPlayer player : activePlayers.keySet().toArray(new ServerPlayer[0])) {
            ServerLevel level;
            try {
                level = (ServerLevel)player.level();
            }
            catch (ClassCastException e) {
                continue;
            }
            long now = level.getGameTime();
            long end = activePlayers.get(player);
            if (now > end) {
                activePlayers.remove(player);
                lastPlay.remove(player);
                continue;
            }
            long last = lastPlay.getOrDefault(player, now);
            if (now - last < 10L) continue;
            lastPlay.put(player, now);
            Vec3 pos = player.position();
            SoundEvent sound = SCARY_SOUNDS[random.nextInt(SCARY_SOUNDS.length)];
            float pitch = 0.8f + random.nextFloat() * 0.4f;
            float volume = 0.8f + random.nextFloat() * 0.4f;
            player.playNotifySound(sound, SoundSource.PLAYERS, volume, pitch);
        }
    }
}

