/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class events6 {
    private static final Map<ServerPlayer, Integer> playerTimers = new HashMap<ServerPlayer, Integer>();

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            if (player.level().isClientSide()) continue;
            playerTimers.put(player, 40);
            events6.startBlockBreaking(player);
        }
    }

    private static void startBlockBreaking(ServerPlayer player) {
        Level level = player.level();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (!playerTimers.containsKey(player)) {
                return;
            }
            int remainingTicks = playerTimers.get(player) - 1;
            if (remainingTicks < 0) {
                playerTimers.remove(player);
                return;
            }
            playerTimers.put(player, remainingTicks);
            int blocksDown = player.isSprinting() ? 2 : 1;
            BlockPos base = player.blockPosition().below();
            for (int i = 0; i < blocksDown; ++i) {
                BlockPos pos = base.below(i);
                if (level.getBlockState(pos).isAir()) continue;
                level.destroyBlock(pos, true);
            }
        }, 0L, 300L, TimeUnit.MILLISECONDS);
    }
}

