/*
 * Decompiled with CFR 0.152.
 */
package com.example.brokenbows.events;

import com.example.brokenbows.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brokenbows", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BowEvents {
    private static final Random random = new Random();
    private static final int OVERDRAW_TICKS = 120;
    private static final Map<Player, Integer> drawStartTimes = new HashMap<Player, Integer>();

    @SubscribeEvent
    public static void onBowBreak(PlayerDestroyItemEvent event) {
        if (event.getOriginal().m_41720_() == Items.f_42411_) {
            double chance = random.nextDouble();
            ItemStack brokenBow = ItemStack.f_41583_;
            if (chance < 0.2) {
                brokenBow = new ItemStack((ItemLike)ModItems.BROKEN_STRING_BOW.get());
            } else if (chance < 0.4) {
                brokenBow = new ItemStack((ItemLike)ModItems.BROKEN_STICK_BOW.get());
            } else if (chance < 0.6) {
                brokenBow = new ItemStack((ItemLike)ModItems.BROKEN_BOTH_BOW.get());
            }
            if (!brokenBow.m_41619_()) {
                BowEvents.consumeArrow(event.getEntity(), event.getOriginal());
                event.getEntity().m_36356_(brokenBow);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onStartDrawing(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().m_41720_() == Items.f_42411_) {
            drawStartTimes.put(event.getEntity(), event.getEntity().f_19797_);
        }
    }

    @SubscribeEvent
    public static void onBowDrawing(TickEvent.PlayerTickEvent event) {
        Integer startTime;
        if (event.phase == TickEvent.Phase.END && event.player.m_6117_() && event.player.m_21211_().m_41720_() == Items.f_42411_ && (startTime = drawStartTimes.get(event.player)) != null && event.player.f_19797_ - startTime > 120) {
            double chance = random.nextDouble();
            ItemStack brokenBow = ItemStack.f_41583_;
            brokenBow = chance < 0.47 ? new ItemStack((ItemLike)ModItems.BROKEN_STRING_BOW.get()) : (chance < 0.94 ? new ItemStack((ItemLike)ModItems.BROKEN_STICK_BOW.get()) : new ItemStack((ItemLike)ModItems.BROKEN_BOTH_BOW.get()));
            BowEvents.consumeArrow(event.player, event.player.m_21211_());
            event.player.m_150109_().m_6836_(event.player.m_150109_().f_35977_, brokenBow);
            event.player.m_5810_();
            BowEvents.spawnShortRangeArrow(event.player, event.player.m_21211_());
            drawStartTimes.remove(event.player);
        }
    }

    private static void consumeArrow(Player player, ItemStack bowStack) {
        ItemStack arrowStack;
        if (!player.m_150110_().f_35937_ && !(arrowStack = player.m_6298_(bowStack)).m_41619_()) {
            arrowStack.m_41774_(1);
            if (arrowStack.m_41619_() && !player.m_150109_().m_36054_(arrowStack)) {
                player.m_36176_(arrowStack, false);
            }
        }
    }

    private static void spawnShortRangeArrow(Player player, ItemStack bowStack) {
        AbstractArrow arrow;
        Item item;
        Level world = player.f_19853_;
        ItemStack arrowStack = player.m_6298_(bowStack);
        if (arrowStack.m_41619_()) {
            arrowStack = new ItemStack((ItemLike)Items.f_42412_);
        }
        if ((item = arrowStack.m_41720_()) instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            arrow = arrowItem.m_6394_(world, arrowStack, (LivingEntity)player);
        } else {
            arrow = ((ArrowItem)Items.f_42412_).m_6394_(world, arrowStack, (LivingEntity)player);
        }
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.5f, 1.0f);
        arrow.m_36781_(0.1);
        arrow.m_36767_((byte)0);
        arrow.m_36735_(0);
        world.m_7967_((Entity)arrow);
        player.m_5496_(SoundEvents.f_11687_, 0.5f, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (BowEvents.isBrokenBow(stack)) {
            event.setCanceled(true);
            event.getEntity().m_5496_(SoundEvents.f_12018_, 0.5f, 0.8f);
        }
    }

    private static boolean isBrokenBow(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41720_() == ModItems.BROKEN_STRING_BOW.get() || stack.m_41720_() == ModItems.BROKEN_STICK_BOW.get() || stack.m_41720_() == ModItems.BROKEN_BOTH_BOW.get();
    }
}

