/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.jacobwasbeast.picaxe.blocks.entities.ModBlockEntities;
import net.jacobwasbeast.picaxe.utils.DataUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ImageBannerBlockEntity
extends BlockEntity {
    public DyeColor color;
    private String imageLocation;
    public BannerRenderTypes renderTypes = BannerRenderTypes.OVER_BANNER;

    public ImageBannerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = DyeColor.WHITE;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public ImageBannerBlockEntity(BlockPos blockPos, BlockState blockState, DyeColor dyeColor) {
        super((BlockEntityType)ModBlockEntities.IMAGE_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BannerRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setRenderTypes(BannerRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setImageLocation(String url) {
        this.imageLocation = url;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(ValueOutput compoundTag) {
        super.saveAdditional(compoundTag);
        compoundTag.putString("imageLocation", this.imageLocation);
        compoundTag.putString("color", this.color.getName());
        compoundTag.putString("id", "picaxe:image_banner");
        if (this.renderTypes != null) {
            compoundTag.putString("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.putString("renderTypes", BannerRenderTypes.OVER_BANNER.name());
        }
    }

    protected void loadAdditional(ValueInput compoundTag) {
        super.loadAdditional(compoundTag);
        this.imageLocation = (String)compoundTag.getString("imageLocation").get();
        if (compoundTag.getString("imageLocation").isEmpty()) {
            this.imageLocation = "picaxe:blocks/banner";
        }
        this.color = DyeColor.byName((String)((String)compoundTag.getString("color").get()), (DyeColor)DyeColor.WHITE);
        if (compoundTag.getString("renderTypes").isPresent()) {
            try {
                this.renderTypes = BannerRenderTypes.valueOf((String)compoundTag.getString("renderTypes").get());
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BannerRenderTypes.OVER_BANNER;
            }
        } else {
            this.renderTypes = BannerRenderTypes.OVER_BANNER;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void loadFromItemStackComponents(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            this.loadAdditional(DataUtils.getValueInputFromCompoundTag(customData.copyTag()));
        } else {
            this.setColor(DyeColor.WHITE);
            this.setImageLocation("");
            this.setRenderTypes(BannerRenderTypes.OVER_BANNER);
        }
    }
}

