/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ImageShieldModelRenderer
implements SpecialModelRenderer<String> {
    private static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace((String)"entity/shield_base"));
    private static final Material SHIELD_BASE_NOPATTEN = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace((String)"entity/shield_base_nopattern"));
    private final ModelPart plate;
    private final ModelPart handle;

    public ImageShieldModelRenderer(EntityModelSet modelSet) {
        ModelPart shieldModel = modelSet.bakeLayer(ModelLayers.SHIELD);
        this.plate = shieldModel.getChild("plate");
        this.handle = shieldModel.getChild("handle");
    }

    @Nullable
    public String extractArgument(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            CompoundTag tag = customData.copyTag();
            return (String)tag.getString("imageLocation").get();
        }
        return null;
    }

    public void getExtents(Set<Vector3f> extents) {
        extents.add(new Vector3f(-0.5f, -0.5f, -0.5f));
        extents.add(new Vector3f(0.5f, 0.5f, 0.5f));
        extents.add(new Vector3f(-0.6f, -0.6f, -0.6f));
        extents.add(new Vector3f(0.6f, 0.6f, 0.6f));
    }

    public void render(@Nullable String imageUrl, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean hasGlint) {
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        boolean isGUI = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.FIXED;
        Material baseMaterial = isGUI ? SHIELD_BASE : SHIELD_BASE_NOPATTEN;
        VertexConsumer baseConsumer = baseMaterial.buffer(buffer, RenderType::entitySolid);
        ItemStack heldStack = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getUseItem() : ItemStack.EMPTY;
        this.handle.render(poseStack, baseConsumer, packedLight, packedOverlay);
        this.plate.render(poseStack, baseConsumer, packedLight, packedOverlay);
        if (imageUrl != null && !imageUrl.isBlank()) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(-0.5, (double)-0.88f, -0.5);
            ImageUtils.renderImageFromURL(poseStack, buffer, packedLight, packedOverlay, 0.0f, 0.63f, 1.25f, imageUrl);
        }
        poseStack.popPose();
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return CODEC;
        }

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new ImageShieldModelRenderer(modelSet);
        }
    }
}

