/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import net.blay09.mods.balm.api.Balm;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;

public class ImageFrameConfigScreen
extends Screen {
    private static final int BACKGROUND_COLOR = -436207616;
    private static final int PANEL_COLOR = -870704614;
    private static final int ACCENT_COLOR = -13330213;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -7829368;
    private static final int ERROR_COLOR = -1618884;
    private static final int SUCCESS_COLOR = -13710223;
    private static final int REMOVE_COLOR = -38091;
    private final ImageFrameBlockEntity blockEntity;
    private EditBox urlInput;
    private EditBox widthInput;
    private EditBox heightInput;
    private Button stretchButton;
    private Button confirmButton;
    private Button cancelButton;
    private Button clearButton;
    private boolean shouldStretch;
    private String urlValue;
    private String widthValue;
    private String heightValue;
    private String errorMessage = "";
    private int errorTimer = 0;
    private float animationProgress = 0.0f;
    private boolean urlChanged = false;

    public ImageFrameConfigScreen(ImageFrameBlockEntity be) {
        super((Component)Component.translatable((String)"picaxe.screen.image_frame.title"));
        this.blockEntity = be;
        this.shouldStretch = be.shouldStretchToFit();
        this.urlValue = be.getImageUrl();
        this.widthValue = String.valueOf(be.getFrameWidth());
        this.heightValue = String.valueOf(be.getFrameHeight());
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 360;
        int panelHeight = 240;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        this.urlInput = new EditBox(this.font, panelX + 30, panelY + 65, panelWidth - 90, 20, (Component)Component.translatable((String)"picaxe.screen.url_input.url"));
        this.urlInput.setMaxLength(256);
        this.urlInput.setValue(this.urlValue);
        this.urlInput.setHint((Component)Component.translatable((String)"picaxe.screen.image_frame.url_hint"));
        this.urlInput.setBordered(false);
        this.urlInput.setResponder(text -> {
            this.urlChanged = !text.equals(this.blockEntity.getImageUrl());
        });
        this.addWidget((GuiEventListener)this.urlInput);
        this.setInitialFocus((GuiEventListener)this.urlInput);
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.image_frame.clear_icon"), button -> {
            this.urlInput.setValue("");
            this.urlChanged = true;
        }).bounds(panelX + panelWidth - 55, panelY + 65, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.image_frame.clear_tooltip"))).build());
        int inputWidth = (panelWidth - 90) / 2;
        this.widthInput = new EditBox(this.font, panelX + 30, panelY + 115, inputWidth, 20, (Component)Component.translatable((String)"picaxe.screen.image_frame.width"));
        this.widthInput.setValue(this.widthValue);
        this.widthInput.setHint((Component)Component.translatable((String)"picaxe.screen.image_frame.width_hint"));
        this.widthInput.setBordered(false);
        this.widthInput.setTooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.image_frame.width_tooltip")));
        this.addWidget((GuiEventListener)this.widthInput);
        this.heightInput = new EditBox(this.font, panelX + 30 + inputWidth + 30, panelY + 115, inputWidth, 20, (Component)Component.translatable((String)"picaxe.screen.image_frame.height"));
        this.heightInput.setValue(this.heightValue);
        this.heightInput.setHint((Component)Component.translatable((String)"picaxe.screen.image_frame.height_hint"));
        this.heightInput.setBordered(false);
        this.heightInput.setTooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.image_frame.height_tooltip")));
        this.addWidget((GuiEventListener)this.heightInput);
        this.stretchButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getStretchButtonText(), button -> {
            this.shouldStretch = !this.shouldStretch;
            button.setMessage(this.getStretchButtonText());
        }).bounds(panelX + 30, panelY + 155, panelWidth - 60, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.image_frame.stretch_tooltip"))).build());
        int buttonWidth = (panelWidth - 90) / 2;
        this.confirmButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.image_frame.confirm_button"), button -> {
            if (this.validateInputs()) {
                try {
                    int width = Integer.parseInt(this.widthInput.getValue());
                    int height = Integer.parseInt(this.heightInput.getValue());
                    String url = this.urlInput.getValue();
                    BlockPos pos = this.blockEntity.getBlockPos();
                    Balm.getNetworking().sendToServer((CustomPacketPayload)new UpdateImageFramePayload(pos, url, width, height, this.shouldStretch));
                    this.minecraft.setScreen(null);
                }
                catch (NumberFormatException e) {
                    this.setError(Component.translatable((String)"picaxe.screen.image_frame.error.invalid_dimensions").getString());
                }
            }
        }).bounds(panelX + 30, panelY + 190, buttonWidth, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"picaxe.screen.image_frame.confirm_tooltip"))).build());
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.image_frame.cancel_button"), button -> this.minecraft.setScreen(null)).bounds(panelX + 30 + buttonWidth + 30, panelY + 190, buttonWidth, 20).build());
    }

    private boolean validateInputs() {
        String url = this.urlInput.getValue().trim();
        try {
            int width = Integer.parseInt(this.widthInput.getValue());
            int height = Integer.parseInt(this.heightInput.getValue());
            if (width <= 0 || height <= 0) {
                this.setError(Component.translatable((String)"picaxe.screen.image_frame.error.negative_dimensions").getString());
                return false;
            }
            if (width > 6 || height > 6) {
                this.setError(Component.translatable((String)"picaxe.screen.image_frame.error.dimensions_too_large").getString());
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.setError(Component.translatable((String)"picaxe.screen.image_frame.error.invalid_dimensions").getString());
            return false;
        }
        return true;
    }

    private void setError(String message) {
        this.errorMessage = message;
        this.errorTimer = 60;
    }

    private Component getStretchButtonText() {
        MutableComponent icon = this.shouldStretch ? Component.translatable((String)"picaxe.screen.image_frame.stretch_icon_on") : Component.translatable((String)"picaxe.screen.image_frame.stretch_icon_off");
        MutableComponent state = this.shouldStretch ? Component.translatable((String)"picaxe.screen.image_frame.stretch_on") : Component.translatable((String)"picaxe.screen.image_frame.stretch_off");
        return icon.copy().append((Component)Component.translatable((String)"picaxe.screen.image_frame.stretch_mode", (Object[])new Object[]{state}));
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.urlValue = this.urlInput.getValue();
        this.widthValue = this.widthInput.getValue();
        this.heightValue = this.heightInput.getValue();
        boolean wasUrlChanged = this.urlChanged;
        this.init(minecraft, width, height);
        this.urlChanged = wasUrlChanged;
    }

    public void tick() {
        super.tick();
        if (this.errorTimer > 0) {
            --this.errorTimer;
        }
        this.animationProgress = Math.min(1.0f, this.animationProgress + 0.1f);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float alpha = Mth.lerp((float)partialTick, (float)(this.animationProgress - 0.1f), (float)this.animationProgress);
        guiGraphics.fill(0, 0, this.width, this.height, -436207616);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 360;
        int panelHeight = 240;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.fill(panelX + 2, panelY + 2, panelX + panelWidth + 2, panelY + panelHeight + 2, 0x44000000);
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -870704614);
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + 3, -13330213);
        guiGraphics.drawCenteredString(this.font, this.title, centerX, panelY + 15, -1);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"picaxe.screen.image_frame.subtitle"), centerX, panelY + 30, -7829368);
        guiGraphics.fill(panelX + 30, panelY + 50, panelX + panelWidth - 30, panelY + 51, 0x44FFFFFF);
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 65, panelWidth - 90, 20, this.urlInput.isFocused());
        int inputWidth = (panelWidth - 90) / 2;
        this.renderInputBackground(guiGraphics, panelX + 30, panelY + 115, inputWidth, 20, this.widthInput.isFocused());
        this.renderInputBackground(guiGraphics, panelX + 30 + inputWidth + 30, panelY + 115, inputWidth, 20, this.heightInput.isFocused());
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"picaxe.screen.image_frame.url_label"), panelX + 30, panelY + 52, -7829368);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"picaxe.screen.image_frame.dimensions_label"), panelX + 30, panelY + 102, -7829368);
        if (this.urlInput.getValue().trim().isEmpty()) {
            guiGraphics.fill(panelX + 10, panelY + 65, panelX + 13, panelY + 85, -38091);
            MutableComponent removeMode = Component.translatable((String)"picaxe.screen.image_frame.remove_mode");
            guiGraphics.drawString(this.font, (Component)removeMode, panelX + 30, panelY + 90, -38091);
        } else if (this.urlChanged) {
            guiGraphics.fill(panelX + 10, panelY + 65, panelX + 13, panelY + 85, -13710223);
        }
        if (this.errorTimer > 0 && !this.errorMessage.isEmpty()) {
            int errorAlpha = Math.min(255, this.errorTimer * 255 / 60);
            int errorColor = errorAlpha << 24 | 0xE74C3C;
            guiGraphics.drawCenteredString(this.font, this.errorMessage, centerX, panelY + panelHeight - 15, errorColor);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.urlInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.widthInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.heightInput.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderInputBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, boolean focused) {
        int bgColor = focused ? -14013910 : -14737633;
        int borderColor = focused ? -13330213 : -12961222;
        guiGraphics.fill(x, y, x + width, y + height, bgColor);
        guiGraphics.fill(x - 1, y - 1, x + width + 1, y, borderColor);
        guiGraphics.fill(x - 1, y + height, x + width + 1, y + height + 1, borderColor);
        guiGraphics.fill(x - 1, y, x, y + height, borderColor);
        guiGraphics.fill(x + width, y, x + width + 1, y + height, borderColor);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

