/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.jacobwasbeast.picaxe.items.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class ImageShieldItem
extends ShieldItem {
    public ImageShieldItem(Item.Properties properties) {
        super(properties.durability(336).component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).repairable(ItemTags.WOODEN_TOOL_MATERIALS).equippableUnswappable(EquipmentSlot.OFFHAND).component(DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(0.25f, 1.0f, List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f)), new BlocksAttacks.ItemDamageFunction(3.0f, 1.0f, 1.0f), Optional.of(DamageTypeTags.BYPASSES_SHIELD), Optional.of(SoundEvents.SHIELD_BLOCK), Optional.of(SoundEvents.SHIELD_BREAK))).component(DataComponents.BREAK_SOUND, (Object)SoundEvents.SHIELD_BREAK));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        CompoundTag tag;
        String imageUrl;
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        CustomData customData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && !(imageUrl = (String)(tag = customData.copyTag()).getString("imageLocation").get()).isBlank()) {
            consumer.accept((Component)Component.literal((String)"URL: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)imageUrl).withStyle(ChatFormatting.AQUA)));
        }
    }

    public static ItemStack createFromBanner(ItemStack bannerStack) {
        ItemStack shieldStack = new ItemStack((ItemLike)ModItems.IMAGE_SHIELD);
        CustomData bannerData = (CustomData)bannerStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (bannerData != null) {
            CompoundTag newTag = bannerData.copyTag();
            shieldStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)newTag));
        }
        return shieldStack;
    }
}

