/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.mixin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.jacobwasbeast.picaxe.api.interfaces.ModelManagerMixinInterface;
import net.jacobwasbeast.picaxe.mixin.ModelManagerInvoker;
import net.minecraft.TracingExecutor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelManager.class})
public abstract class ModelManagerMixin
implements ModelManagerMixinInterface {
    @Shadow
    @Mutable
    private Map<ResourceLocation, ItemModel> bakedItemStackModels;
    @Shadow
    @Mutable
    private Map<ResourceLocation, ClientItem.Properties> itemProperties;

    @Override
    public void picAxe$invalidate() {
        ArrayList<String> toRemove = new ArrayList<String>();
        toRemove.add("picaxe:six_sided_image_block");
        toRemove.add("picaxe:image_bed");
        toRemove.add("picaxe:image_banner");
        toRemove.add("picaxe:image_shield");
        HashMap<ResourceLocation, ItemModel> newModels = new HashMap<ResourceLocation, ItemModel>(this.bakedItemStackModels);
        HashMap<ResourceLocation, ClientItem.Properties> newProps = new HashMap<ResourceLocation, ClientItem.Properties>(this.itemProperties);
        boolean any = false;
        for (ResourceLocation loc : this.bakedItemStackModels.keySet()) {
            if (!toRemove.contains(loc.getNamespace() + ":" + loc.getPath())) continue;
            System.out.println("Picaxe: Invalidating item model " + String.valueOf(loc));
            newModels.remove(loc);
            newProps.remove(loc);
            any = true;
        }
        if (!any) {
            return;
        }
        this.bakedItemStackModels = newModels;
        this.itemProperties = newProps;
        Minecraft mc = Minecraft.getInstance();
        ResourceManager rm = mc.getResourceManager();
        TracingExecutor prepExec = Util.backgroundExecutor();
        Minecraft applyExec = mc;
        PreparableReloadListener.PreparationBarrier barrier = new PreparableReloadListener.PreparationBarrier(this){

            public <T> CompletableFuture<T> wait(T f) {
                return CompletableFuture.completedFuture(f);
            }
        };
        CompletableFuture<Void> cf = ((ModelManagerInvoker)((Object)this)).invokeReload(barrier, rm, (Executor)prepExec, (Executor)applyExec);
        cf.exceptionally(t -> {
            t.printStackTrace();
            return null;
        });
    }
}

