/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.network;

import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public record UpdateImageFramePayload(BlockPos pos, String url, int width, int height, boolean stretch) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateImageFramePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)"picaxe", (String)"update_image_frame"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateImageFramePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateImageFramePayload::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateImageFramePayload::url, (StreamCodec)ByteBufCodecs.INT, UpdateImageFramePayload::width, (StreamCodec)ByteBufCodecs.INT, UpdateImageFramePayload::height, (StreamCodec)ByteBufCodecs.BOOL, UpdateImageFramePayload::stretch, UpdateImageFramePayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ServerPlayer player, UpdateImageFramePayload payload) {
        BlockEntity be;
        ServerLevel level = player.level();
        if (level.isLoaded(payload.pos) && (be = level.getBlockEntity(payload.pos)) instanceof ImageFrameBlockEntity) {
            ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)be;
            frameEntity.setConfiguration(payload.url, payload.width, payload.height, payload.stretch);
        }
    }
}

