/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.ValueInput;

public class DataUtils {
    public static ValueInput getValueInputFromCompoundTag(CompoundTag tag) {
        return new CompoundTagValueInput(tag);
    }

    private static final class CompoundTagValueInput
    implements ValueInput {
        private final CompoundTag tag;
        private static final ValueInput.ValueInputList EMPTY_COMPOUND_LIST = new CompoundTagListValueInput(new ListTag());

        public CompoundTagValueInput(CompoundTag tag) {
            this.tag = tag;
        }

        public <T> Optional<T> read(String key, Codec<T> codec) {
            return this.tag.read(key, codec, (DynamicOps)NbtOps.INSTANCE);
        }

        @Deprecated
        public <T> Optional<T> read(MapCodec<T> codec) {
            return this.tag.read(codec, (DynamicOps)NbtOps.INSTANCE);
        }

        public Optional<ValueInput> child(String key) {
            return this.tag.getCompound(key).map(CompoundTagValueInput::new);
        }

        public ValueInput childOrEmpty(String key) {
            return new CompoundTagValueInput(this.tag.getCompoundOrEmpty(key));
        }

        public Optional<ValueInput.ValueInputList> childrenList(String key) {
            return Optional.ofNullable(this.tag.get(key)).filter(ListTag.class::isInstance).map(ListTag.class::cast).filter(list -> list.isEmpty() || list.get(0) instanceof CompoundTag).map(CompoundTagListValueInput::new);
        }

        public ValueInput.ValueInputList childrenListOrEmpty(String key) {
            return this.childrenList(key).orElse(EMPTY_COMPOUND_LIST);
        }

        public <T> Optional<ValueInput.TypedInputList<T>> list(String key, Codec<T> codec) {
            return this.tag.getList(key).map(listTag -> new TypedListValueInput((ListTag)listTag, codec));
        }

        public <T> ValueInput.TypedInputList<T> listOrEmpty(String key, Codec<T> codec) {
            return new TypedListValueInput<T>(this.tag.getListOrEmpty(key), codec);
        }

        public boolean getBooleanOr(String key, boolean defaultValue) {
            return this.tag.getBooleanOr(key, defaultValue);
        }

        public byte getByteOr(String key, byte defaultValue) {
            return this.tag.getByteOr(key, defaultValue);
        }

        public int getShortOr(String key, short defaultValue) {
            return this.tag.getShortOr(key, defaultValue);
        }

        public Optional<Integer> getInt(String key) {
            return this.tag.getInt(key);
        }

        public int getIntOr(String key, int defaultValue) {
            return this.tag.getIntOr(key, defaultValue);
        }

        public long getLongOr(String key, long defaultValue) {
            return this.tag.getLongOr(key, defaultValue);
        }

        public Optional<Long> getLong(String key) {
            return this.tag.getLong(key);
        }

        public float getFloatOr(String key, float defaultValue) {
            return this.tag.getFloatOr(key, defaultValue);
        }

        public double getDoubleOr(String key, double defaultValue) {
            return this.tag.getDoubleOr(key, defaultValue);
        }

        public Optional<String> getString(String key) {
            return this.tag.getString(key);
        }

        public String getStringOr(String key, String defaultValue) {
            return this.tag.getStringOr(key, defaultValue);
        }

        public Optional<int[]> getIntArray(String key) {
            return this.tag.getIntArray(key);
        }

        @Deprecated
        public HolderLookup.Provider lookup() {
            return new HolderLookup.Provider(this){

                public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                    return Stream.empty();
                }

                public <T> Optional<? extends HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> resourceKey) {
                    return Optional.empty();
                }
            };
        }
    }

    private static final class TypedListValueInput<T>
    implements ValueInput.TypedInputList<T> {
        private final ListTag listTag;
        private final Codec<T> codec;

        public TypedListValueInput(ListTag listTag, Codec<T> codec) {
            this.listTag = listTag;
            this.codec = codec;
        }

        public boolean isEmpty() {
            return this.listTag.isEmpty();
        }

        public Stream<T> stream() {
            return this.listTag.stream().map(tag -> this.codec.parse((DynamicOps)NbtOps.INSTANCE, tag)).flatMap(dataResult -> dataResult.result().stream());
        }

        public Iterator<T> iterator() {
            return this.stream().iterator();
        }
    }

    private static final class CompoundTagListValueInput
    implements ValueInput.ValueInputList {
        private final ListTag listTag;

        public CompoundTagListValueInput(ListTag listTag) {
            this.listTag = listTag;
        }

        public boolean isEmpty() {
            return this.listTag.isEmpty();
        }

        public Stream<ValueInput> stream() {
            return this.listTag.stream().map(tag -> (CompoundTag)tag).map(CompoundTagValueInput::new);
        }

        public Iterator<ValueInput> iterator() {
            return this.stream().iterator();
        }
    }
}

