/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.function.Supplier;
import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.ModBlocks;
import net.jacobwasbeast.picaxe.ModCreativeTabs;
import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.ModRecipes;
import net.jacobwasbeast.picaxe.component.ModDataComponents;
import net.jacobwasbeast.picaxe.network.PacketHandler;
import net.jacobwasbeast.picaxe.utils.ClientUtils;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Main {
    public static final String MOD_ID = "picaxe";
    public static final Logger LOGGER = LogManager.getLogger((String)"picaxe");
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));

    public static void init() {
        ModDataComponents.register();
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModRecipes.register();
        ModCreativeTabs.register();
        PacketHandler.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ClientUtils.registerRenderers();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.tryBuild((String)MOD_ID, (String)path);
    }
}

