/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks;

import java.util.Collections;
import java.util.List;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBedBlockEntity;
import net.jacobwasbeast.picaxe.items.ImageBedBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class ImageBedBlock
extends BedBlock {
    public ImageBedBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ImageBedBlockEntity(blockPos, blockState, this.getColor());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos headPos;
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(headPos = state.getValue((Property)PART) == BedPart.HEAD ? pos : pos.relative((Direction)state.getValue((Property)FACING)))) instanceof ImageBedBlockEntity) {
            ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)blockEntity;
            imageBedEntity.loadFromItemStackComponents(stack);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        if (state.getValue((Property)PART) == BedPart.HEAD && (blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof ImageBedBlockEntity) {
            ImageBedBlockEntity bedEntity = (ImageBedBlockEntity)blockEntity;
            ItemStack itemStackToDrop = ImageBedBlockItem.create(bedEntity.getColor(), bedEntity.getImageLocation(), bedEntity.getRenderTypes());
            return Collections.singletonList(itemStackToDrop);
        }
        return Collections.emptyList();
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        level.levelEvent(player, 2001, blockPos, ImageBedBlock.getId((BlockState)Blocks.WHITE_BED.defaultBlockState()));
    }
}

