/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ImageFrameBlock
extends DirectionalBlock
implements EntityBlock {
    public ImageFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return MapCodec.unit((Object)((Object)this));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ImageFrameBlockEntity(pos, state);
    }

    protected VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        float frameWidthScale = 1.0f;
        float frameHeightScale = 1.0f;
        BlockEntity be = blockGetter.getBlockEntity(blockPos);
        if (be instanceof ImageFrameBlockEntity) {
            ImageFrameBlockEntity imageFrame = (ImageFrameBlockEntity)be;
            frameWidthScale = imageFrame.getFrameWidth();
            frameHeightScale = imageFrame.getFrameHeight();
        }
        double width = (double)frameWidthScale * 16.0;
        double height = (double)frameHeightScale * 16.0;
        double xOffset = (16.0 - width) / 2.0;
        double yOffset = (16.0 - height) / 2.0;
        double zOffsetForWidth = (16.0 - width) / 2.0;
        double zOffsetForHeight = (16.0 - height) / 2.0;
        switch (facing) {
            case NORTH: {
                return Block.box((double)xOffset, (double)yOffset, (double)15.0, (double)(16.0 - xOffset), (double)(16.0 - yOffset), (double)16.0);
            }
            case SOUTH: {
                return Block.box((double)xOffset, (double)yOffset, (double)0.0, (double)(16.0 - xOffset), (double)(16.0 - yOffset), (double)1.0);
            }
            case WEST: {
                return Block.box((double)15.0, (double)yOffset, (double)zOffsetForWidth, (double)16.0, (double)(16.0 - yOffset), (double)(16.0 - zOffsetForWidth));
            }
            case EAST: {
                return Block.box((double)0.0, (double)yOffset, (double)zOffsetForWidth, (double)1.0, (double)(16.0 - yOffset), (double)(16.0 - zOffsetForWidth));
            }
            case DOWN: {
                return Block.box((double)xOffset, (double)15.0, (double)zOffsetForHeight, (double)(16.0 - xOffset), (double)16.0, (double)(16.0 - zOffsetForHeight));
            }
            case UP: {
                return Block.box((double)xOffset, (double)0.0, (double)zOffsetForHeight, (double)(16.0 - xOffset), (double)1.0, (double)(16.0 - zOffsetForHeight));
            }
        }
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity adjacentBlockEntity = level.getBlockEntity(blockPos.relative(((Direction)blockState.getValue((Property)FACING)).getOpposite()));
        if (adjacentBlockEntity instanceof SixSidedImageBlockEntity) {
            level.setBlock(blockPos, blockState2, 3);
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)this));
            itemEntity.setDefaultPickUpDelay();
            itemEntity.setExtendedLifetime();
            level.addFreshEntity((Entity)itemEntity);
        } else {
            super.onPlace(blockState, level, blockPos, blockState2, bl);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ImageFrameBlockEntity) {
            ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)blockEntity;
            ItemStack itemStackToDrop = new ItemStack((ItemLike)frameEntity.getBlockState().getBlock());
            return Collections.singletonList(itemStackToDrop);
        }
        return super.getDrops(state, builder);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        level.levelEvent(player, 2001, blockPos, ImageFrameBlock.getId((BlockState)Blocks.OAK_PLANKS.defaultBlockState()));
    }
}

