/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks;

import java.util.Collections;
import java.util.List;
import net.jacobwasbeast.picaxe.blocks.entities.ImageWallBannerBlockEntity;
import net.jacobwasbeast.picaxe.items.ImageBannerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ImageWallBannerBlock
extends WallBannerBlock {
    public ImageWallBannerBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ImageWallBannerBlockEntity(blockPos, blockState, this.getColor());
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ImageWallBannerBlockEntity) {
            ImageWallBannerBlockEntity bannerEntity = (ImageWallBannerBlockEntity)blockEntity;
            ItemStack itemStackToDrop = ImageBannerItem.create(bannerEntity.getColor(), bannerEntity.getImageLocation(), bannerEntity.getRenderTypes());
            return Collections.singletonList(itemStackToDrop);
        }
        return super.getDrops(state, builder);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        level.levelEvent(player, 2001, blockPos, ImageWallBannerBlock.getId((BlockState)Blocks.WHITE_BANNER.defaultBlockState()));
    }
}

