/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.entities;

import java.net.URI;
import java.net.URISyntaxException;
import net.jacobwasbeast.picaxe.ModBlockEntities;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ImageWallBannerBlockEntity
extends BlockEntity {
    public DyeColor color;
    private String imageLocation;
    public BannerRenderTypes renderTypes = BannerRenderTypes.OVER_BANNER;

    public ImageWallBannerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = DyeColor.WHITE;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public ImageWallBannerBlockEntity(BlockPos blockPos, BlockState blockState, DyeColor dyeColor) {
        super((BlockEntityType)ModBlockEntities.IMAGE_WALL_BANNER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.color = dyeColor;
        this.imageLocation = "picaxe:blocks/banner";
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BannerRenderTypes getRenderTypes() {
        return this.renderTypes;
    }

    public void setColor(DyeColor dyeColor) {
        this.color = dyeColor;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setRenderTypes(BannerRenderTypes renderTypes) {
        this.renderTypes = renderTypes;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setImageLocation(String url) {
        URI uri;
        try {
            String encodedUrl = url.replace(" ", "%20");
            uri = new URI(encodedUrl);
            if (!uri.isAbsolute() || uri.getScheme() == null || uri.getHost() == null) {
                throw new URISyntaxException(url, "URL is not absolute");
            }
        }
        catch (URISyntaxException e) {
            if (this.level != null && this.level.isClientSide()) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"picaxe.errors.invalid_url_format"));
            }
            return;
        }
        String path = uri.getPath();
        if (path == null || !path.toLowerCase().endsWith(".png") && !path.toLowerCase().endsWith(".jpg") && !path.toLowerCase().endsWith(".jpeg")) {
            if (this.level != null && this.level.isClientSide()) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"picaxe.errors.invalid_image_extension"));
            }
            return;
        }
        this.imageLocation = uri.toString();
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putString("imageLocation", this.imageLocation);
        compoundTag.putString("color", this.color.getName());
        compoundTag.putString("id", "picaxe:image_banner");
        if (this.renderTypes != null) {
            compoundTag.putString("renderTypes", this.renderTypes.name());
        } else {
            compoundTag.putString("renderTypes", BannerRenderTypes.OVER_BANNER.name());
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.imageLocation = compoundTag.getString("imageLocation");
        if (!compoundTag.contains("imageLocation")) {
            this.imageLocation = "picaxe:blocks/banner";
        }
        this.color = DyeColor.byName((String)compoundTag.getString("color"), (DyeColor)DyeColor.WHITE);
        if (compoundTag.contains("renderTypes")) {
            try {
                this.renderTypes = BannerRenderTypes.valueOf(compoundTag.getString("renderTypes"));
            }
            catch (IllegalArgumentException e) {
                this.renderTypes = BannerRenderTypes.OVER_BANNER;
            }
        } else {
            this.renderTypes = BannerRenderTypes.OVER_BANNER;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

