/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.blocks.entities.ImageWallBannerBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class ImageWallBannerBlockRenderer
implements BlockEntityRenderer<ImageWallBannerBlockEntity> {
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;

    public ImageWallBannerBlockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.bakeLayer(ModelLayers.BANNER);
        this.flag = modelPart.getChild("flag");
        this.pole = modelPart.getChild("pole");
        this.bar = modelPart.getChild("bar");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("flag", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("pole", CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("bar", CubeListBuilder.create().texOffs(0, 42).addBox(-10.0f, -32.0f, -1.0f, 20.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(ImageWallBannerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float xRot;
        String imageUrl = blockEntity.getImageLocation();
        poseStack.pushPose();
        long gameTime = blockEntity.hasLevel() ? blockEntity.getLevel().getGameTime() : 0L;
        BlockState blockState = blockEntity.getBlockState();
        if (blockState.getBlock() instanceof BannerBlock) {
            poseStack.translate(0.5, 0.5, 0.5);
            rotation = -RotationSegment.convertToDegrees((int)((Integer)blockState.getValue((Property)BannerBlock.ROTATION)));
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            this.pole.visible = true;
        } else {
            poseStack.translate(0.5, -0.16666667, 0.5);
            rotation = -((Direction)blockState.getValue((Property)WallBannerBlock.FACING)).toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.translate(0.0, -0.3125, -0.4375);
            this.pole.visible = false;
        }
        poseStack.pushPose();
        poseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer poleAndBarConsumer = ModelBakery.BANNER_BASE.buffer(bufferSource, RenderType::entitySolid);
        this.pole.render(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        this.bar.render(poseStack, poleAndBarConsumer, packedLight, packedOverlay);
        BlockPos blockPos = blockEntity.getBlockPos();
        float windAnimation = ((float)Math.floorMod((long)(blockPos.getX() * 7 + blockPos.getY() * 9 + blockPos.getZ() * 13) + gameTime, 100L) + partialTick) / 100.0f;
        this.flag.xRot = xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * windAnimation))) * (float)Math.PI;
        this.flag.y = -32.0f;
        BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)blockEntity.getColor(), (BannerPatternLayers)BannerPatternLayers.EMPTY);
        if (imageUrl != null && !imageUrl.equals("picaxe:blocks/banner") && !imageUrl.isBlank()) {
            poseStack.pushPose();
            this.flag.translateAndRotate(poseStack);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.5, -0.88, -1.75);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, packedLight, packedOverlay, partialTick, 1.25f, 2.5f, imageUrl);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }
}

