/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.ModBlocks;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.jacobwasbeast.picaxe.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SixSidedImageBlockRenderer
implements BlockEntityRenderer<SixSidedImageBlockEntity> {
    public SixSidedImageBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SixSidedImageBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int faceLight;
        String imageUrl;
        Level level = blockEntity.getLevel();
        if (level == null) {
            SixSidedImageBlockEntity newSix = new SixSidedImageBlockEntity(Minecraft.getInstance().player.getOnPos().east(64), ((Block)ModBlocks.SIX_SIDED_IMAGE_BLOCK.get()).defaultBlockState());
            blockEntity.getImages().forEach((direction, s) -> newSix.setImageUrl((Direction)direction, (String)s));
            blockEntity = newSix;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        float seemingOffset = RenderUtils.getSeamOffset((Player)player, blockEntity.getBlockPos());
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            imageUrl = blockEntity.getImageUrl(dir);
            if (imageUrl == null || imageUrl.isBlank()) continue;
            poseStack.pushPose();
            faceLight = level == null ? packedLight : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().relative(dir));
            poseStack.mulPose(dir.getRotation());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            switch (dir) {
                case NORTH: {
                    poseStack.translate(0.0f, -1.0f - seemingOffset, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(-1.0f, -seemingOffset, 0.0f);
                    break;
                }
                case EAST: {
                    poseStack.translate(0.0f, -seemingOffset, 0.0f);
                    break;
                }
                case WEST: {
                    poseStack.translate(-1.0f, -1.0f - seemingOffset, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(dir));
                }
            }
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, 1.0f, 1.0f, imageUrl);
            poseStack.popPose();
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            imageUrl = blockEntity.getImageUrl(dir);
            if (imageUrl == null || imageUrl.isBlank()) continue;
            poseStack.pushPose();
            faceLight = level == null ? packedLight : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().relative(dir));
            poseStack.translate(0.5, 0.5, 0.5);
            if (dir == Direction.UP) {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
            } else if (dir == Direction.DOWN) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(-180.0f));
            }
            poseStack.translate(0.0, 0.0, 0.501);
            poseStack.translate(0.0f, -seemingOffset, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.5, -0.5, 0.0);
            ImageUtils.renderImageFromURL(poseStack, bufferSource, faceLight, packedOverlay, partialTick, 1.0f, 1.0f, imageUrl);
            poseStack.popPose();
        }
    }
}

