/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.gui;

import dev.architectury.networking.NetworkManager;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class URLInputScreen
extends Screen {
    private final InteractionHand hand;
    private EditBox urlInput;
    private String currentUrl;

    public URLInputScreen(Player player, InteractionHand hand) {
        super((Component)Component.translatable((String)"picaxe.screen.url_input.title"));
        this.hand = hand;
        ItemStack itemStack = player.getItemInHand(hand);
        this.currentUrl = PicAxeItem.getURL(itemStack);
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.urlInput = new EditBox(this.font, centerX - 150, centerY - 40, 300, 20, (Component)Component.translatable((String)"picaxe.screen.url_input.url"));
        this.urlInput.setMaxLength(256);
        this.urlInput.setValue(this.currentUrl);
        this.addWidget((GuiEventListener)this.urlInput);
        this.setInitialFocus((GuiEventListener)this.urlInput);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.url_input.confirm"), button -> {
            NetworkManager.sendToServer((CustomPacketPayload)new UpdatePicAxeUrlPayload(this.urlInput.getValue(), this.hand));
            this.minecraft.setScreen(null);
        }).bounds(centerX - 100, centerY, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"picaxe.screen.url_input.cancel"), button -> this.minecraft.setScreen(null)).bounds(centerX + 2, centerY, 98, 20).build());
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.urlInput.getValue();
        this.init(minecraft, width, height);
        this.urlInput.setValue(s);
    }

    public void onClose() {
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        this.urlInput.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

