/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ImageBannerItem
extends StandingAndWallBlockItem
implements Equipable {
    public ImageBannerItem(Block block, Block block2, Item.Properties properties, Direction direction) {
        super(block, block2, properties, direction);
    }

    public Component getName(ItemStack stack) {
        DyeColor color = ImageBannerItem.getColor(stack);
        String colorName = color.getName().substring(0, 1).toUpperCase() + color.getName().substring(1);
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{colorName});
    }

    public static DyeColor getColor(ItemStack stack) {
        CompoundTag tag;
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && (tag = customData.copyTag()).contains("color")) {
            return DyeColor.byName((String)tag.getString("color"), (DyeColor)DyeColor.WHITE);
        }
        return DyeColor.WHITE;
    }

    public static ItemStack create(DyeColor color, String imageUrl, BannerRenderTypes renderType) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.IMAGE_BANNER_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.putString("id", "picaxe:image_banner");
        tag.putString("color", color.getName());
        tag.putString("imageLocation", imageUrl);
        tag.putString("renderTypes", renderType.name());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        if (clickedFace == Direction.UP) {
            BlockState standingState = this.getBlock().getStateForPlacement(context);
            return this.canPlace(context, standingState) ? standingState : null;
        }
        return super.getPlacementState(context);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GENERIC;
    }
}

