/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import net.jacobwasbeast.picaxe.ModItems;
import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ImageBedBlockItem
extends BlockItem {
    public ImageBedBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component getName(ItemStack stack) {
        DyeColor color = ImageBedBlockItem.getColor(stack);
        String colorName = color.getName().substring(0, 1).toUpperCase() + color.getName().substring(1);
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{colorName});
    }

    public static DyeColor getColor(ItemStack stack) {
        CompoundTag tag;
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && (tag = customData.copyTag()).contains("color")) {
            return DyeColor.byName((String)tag.getString("color"), (DyeColor)DyeColor.WHITE);
        }
        return DyeColor.WHITE;
    }

    public static ItemStack create(DyeColor color, String imageUrl, BedRenderTypes renderType) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.IMAGE_BED_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.putString("id", "picaxe:image_bed");
        tag.putString("color", color.getName());
        tag.putString("imageLocation", imageUrl);
        tag.putString("renderTypes", renderType.name());
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }
}

