/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.List;
import net.jacobwasbeast.picaxe.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ImageShieldItem
extends ShieldItem {
    public ImageShieldItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag;
        String imageUrl;
        super.appendHoverText(stack, context, tooltip, flag);
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && !(imageUrl = (tag = customData.copyTag()).getString("imageLocation")).isBlank()) {
            tooltip.add((Component)Component.literal((String)"URL: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)imageUrl).withStyle(ChatFormatting.AQUA)));
        }
    }

    public static ItemStack createFromBanner(ItemStack bannerStack) {
        ItemStack shieldStack = new ItemStack((ItemLike)ModItems.IMAGE_SHIELD.get());
        CustomData bannerData = (CustomData)bannerStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (bannerData != null) {
            CompoundTag newTag = bannerData.copyTag();
            shieldStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)newTag));
        }
        return shieldStack;
    }
}

