/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.List;
import net.jacobwasbeast.picaxe.ModBlocks;
import net.jacobwasbeast.picaxe.ModCreativeTabs;
import net.jacobwasbeast.picaxe.api.BannerRenderTypes;
import net.jacobwasbeast.picaxe.api.BedRenderTypes;
import net.jacobwasbeast.picaxe.blocks.ImageBannerBlock;
import net.jacobwasbeast.picaxe.blocks.ImageBedBlock;
import net.jacobwasbeast.picaxe.blocks.ImageFrameBlock;
import net.jacobwasbeast.picaxe.blocks.ImageWallBannerBlock;
import net.jacobwasbeast.picaxe.blocks.SixSidedImageBlock;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBannerBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageBedBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.ImageWallBannerBlockEntity;
import net.jacobwasbeast.picaxe.blocks.entities.SixSidedImageBlockEntity;
import net.jacobwasbeast.picaxe.component.ModDataComponents;
import net.jacobwasbeast.picaxe.utils.ClientUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class PicAxeItem
extends AxeItem {
    public static final String DEFAULT_URL = "picaxe:blocks/bed";

    public PicAxeItem() {
        super((Tier)Tiers.IRON, new Item.Properties().stacksTo(1).durability(100).component((DataComponentType)ModDataComponents.IMAGE_URL.get(), (Object)DEFAULT_URL).arch$tab(ModCreativeTabs.PICAXE_TAB));
    }

    public static void setURL(ItemStack stack, String url) {
        if (stack.getItem() instanceof PicAxeItem) {
            stack.set((DataComponentType)ModDataComponents.IMAGE_URL.get(), (Object)url);
        }
    }

    public static String getURL(ItemStack stack) {
        return (String)stack.getOrDefault((DataComponentType)ModDataComponents.IMAGE_URL.get(), (Object)DEFAULT_URL);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide && player.isCrouching()) {
            ClientUtils.OpenURLInputScreen(player, hand);
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isCrouching()) {
            return InteractionResult.PASS;
        }
        Level level = useOnContext.getLevel();
        BlockPos clickedPos = useOnContext.getClickedPos();
        BlockState blockState = level.getBlockState(clickedPos);
        Block block = blockState.getBlock();
        ItemStack heldStack = useOnContext.getItemInHand();
        if (block instanceof SixSidedImageBlock) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.getCooldowns().addCooldown((Item)this, 20);
            BlockEntity blockEntity = level.getBlockEntity(clickedPos);
            if (blockEntity instanceof SixSidedImageBlockEntity) {
                SixSidedImageBlockEntity imageBlockEntity = (SixSidedImageBlockEntity)blockEntity;
                Direction face = useOnContext.getClickedFace();
                String imageUrl = PicAxeItem.getURL(heldStack);
                imageBlockEntity.setImageUrl(face, imageUrl);
                if (imageUrl.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_block.remove_face", (Object[])new Object[]{face.getName()}), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_block.set_face", (Object[])new Object[]{face.getName(), imageUrl}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (block instanceof ImageFrameBlock) {
            BlockEntity face;
            if (level.isClientSide && (face = level.getBlockEntity(clickedPos)) instanceof ImageFrameBlockEntity) {
                ImageFrameBlockEntity imageFrameEntity = (ImageFrameBlockEntity)face;
                imageFrameEntity.setConfiguration(imageFrameEntity.getImageUrl(), imageFrameEntity.getFrameWidth(), imageFrameEntity.getFrameHeight(), imageFrameEntity.shouldStretchToFit());
                ClientUtils.OpenImageFrameConfig(player, imageFrameEntity);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (block instanceof BedBlock) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.getCooldowns().addCooldown((Item)this, 20);
            if (block instanceof ImageBedBlock) {
                BlockPos headPos = blockState.getValue((Property)BedBlock.PART) == BedPart.FOOT ? clickedPos.relative((Direction)blockState.getValue((Property)BedBlock.FACING)) : clickedPos;
                Object imageUrl = level.getBlockEntity(headPos);
                if (imageUrl instanceof ImageBedBlockEntity) {
                    ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)((Object)imageUrl);
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBedEntity.getImageLocation().equals(imageUrl)) {
                        int max = BedRenderTypes.values().length;
                        int currentIndex = imageBedEntity.getRenderTypes().ordinal();
                        int nextIndex = (currentIndex + 1) % max;
                        imageBedEntity.setRenderTypes(BedRenderTypes.values()[nextIndex]);
                        player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_bed.render_type", (Object[])new Object[]{imageBedEntity.getRenderTypes().name().toLowerCase()}), true);
                    } else {
                        imageBedEntity.setImageLocation((String)imageUrl);
                        player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_bed.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBedEntity(blockState, clickedPos, level, heldStack);
                player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_bed.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (block instanceof AbstractBannerBlock) {
            if (player.getCooldowns().isOnCooldown((Item)this)) {
                return InteractionResult.FAIL;
            }
            player.getCooldowns().addCooldown((Item)this, 20);
            if (block instanceof ImageBannerBlock || block instanceof ImageWallBannerBlock) {
                int nextIndex;
                int currentIndex;
                int max;
                Object imageUrl;
                BlockEntity imageBannerEntity;
                BlockEntity imageBedEntity = level.getBlockEntity(clickedPos);
                if (imageBedEntity instanceof ImageBannerBlockEntity) {
                    imageBannerEntity = (ImageBannerBlockEntity)imageBedEntity;
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBannerEntity.getImageLocation().equals(imageUrl)) {
                        max = BannerRenderTypes.values().length;
                        if (max > 0) {
                            currentIndex = imageBannerEntity.getRenderTypes().ordinal();
                            nextIndex = (currentIndex + 1) % max;
                            imageBannerEntity.setRenderTypes(BannerRenderTypes.values()[nextIndex]);
                            player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.render_type", (Object[])new Object[]{imageBannerEntity.getRenderTypes().name().toLowerCase()}), true);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.already_set"), true);
                        }
                    } else {
                        imageBannerEntity.setImageLocation((String)imageUrl);
                        player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
                if ((imageUrl = level.getBlockEntity(clickedPos)) instanceof ImageWallBannerBlockEntity) {
                    imageBannerEntity = (ImageWallBannerBlockEntity)((Object)imageUrl);
                    imageUrl = PicAxeItem.getURL(heldStack);
                    if (imageBannerEntity.getImageLocation().equals(imageUrl)) {
                        max = BannerRenderTypes.values().length;
                        if (max > 0) {
                            currentIndex = imageBannerEntity.getRenderTypes().ordinal();
                            nextIndex = (currentIndex + 1) % max;
                            imageBannerEntity.setRenderTypes(BannerRenderTypes.values()[nextIndex]);
                            player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.render_type", (Object[])new Object[]{imageBannerEntity.getRenderTypes().name().toLowerCase()}), true);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.already_set"), true);
                        }
                    } else {
                        imageBannerEntity.setImageLocation((String)imageUrl);
                        player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.set", (Object[])new Object[]{imageUrl}), true);
                    }
                }
            } else {
                this.updateBannerEntity(blockState, clickedPos, level, heldStack);
                player.displayClientMessage((Component)Component.translatable((String)"picaxe.image_banner.set", (Object[])new Object[]{PicAxeItem.getURL(heldStack)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(useOnContext);
    }

    public void updateBedEntity(BlockState blockState, BlockPos clickedPos, Level level, ItemStack stack) {
        BlockPos headPosForColor = blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD ? clickedPos : clickedPos.relative((Direction)blockState.getValue((Property)BedBlock.FACING));
        DyeColor color = DyeColor.WHITE;
        BlockEntity blockEntity = level.getBlockEntity(headPosForColor);
        if (blockEntity instanceof BedBlockEntity) {
            BedBlockEntity bedEntity = (BedBlockEntity)blockEntity;
            color = bedEntity.getColor();
        }
        Direction facing = (Direction)blockState.getValue((Property)BedBlock.FACING);
        BedPart part = (BedPart)blockState.getValue((Property)BedBlock.PART);
        BlockPos otherPartPos = part == BedPart.HEAD ? clickedPos.relative(facing.getOpposite()) : clickedPos.relative(facing);
        ImageBedBlock imageBed = (ImageBedBlock)((Object)ModBlocks.IMAGE_BED_BLOCK.get());
        BlockState newFoot = (BlockState)((BlockState)imageBed.defaultBlockState().setValue((Property)BedBlock.FACING, (Comparable)facing)).setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT);
        BlockState newHead = (BlockState)((BlockState)imageBed.defaultBlockState().setValue((Property)BedBlock.FACING, (Comparable)facing)).setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD);
        BlockPos headPos = part == BedPart.HEAD ? clickedPos : otherPartPos;
        BlockPos footPos = part == BedPart.FOOT ? clickedPos : otherPartPos;
        level.setBlock(footPos, Blocks.AIR.defaultBlockState(), 18);
        level.setBlock(headPos, Blocks.AIR.defaultBlockState(), 18);
        level.setBlock(footPos, newFoot, 3);
        level.setBlock(headPos, newHead, 3);
        BlockEntity blockEntity2 = level.getBlockEntity(headPos);
        if (blockEntity2 instanceof ImageBedBlockEntity) {
            ImageBedBlockEntity imageBedEntity = (ImageBedBlockEntity)blockEntity2;
            imageBedEntity.setColor(color);
            imageBedEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void updateBannerEntity(BlockState blockState, BlockPos clickedPos, Level level, ItemStack stack) {
        BlockEntity imageBannerEntity;
        BlockState newState;
        if (level.isClientSide()) {
            return;
        }
        Block block = blockState.getBlock();
        if (!(block instanceof BannerBlock) && !(block instanceof WallBannerBlock)) {
            return;
        }
        DyeColor color = block instanceof WallBannerBlock ? ((WallBannerBlock)block).getColor() : (block instanceof BannerBlock ? ((BannerBlock)block).getColor() : DyeColor.WHITE);
        if (block instanceof WallBannerBlock) {
            Block newBlock = (Block)ModBlocks.IMAGE_WALL_BANNER_BLOCK.get();
            newState = (BlockState)newBlock.defaultBlockState().setValue((Property)WallBannerBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)WallBannerBlock.FACING)));
        } else {
            Block newBlock = (Block)ModBlocks.IMAGE_BANNER_BLOCK.get();
            newState = (BlockState)newBlock.defaultBlockState().setValue((Property)BannerBlock.ROTATION, (Comparable)((Integer)blockState.getValue((Property)BannerBlock.ROTATION)));
        }
        level.setBlock(clickedPos, newState, 3);
        BlockEntity blockEntity = level.getBlockEntity(clickedPos);
        if (blockEntity instanceof ImageBannerBlockEntity) {
            imageBannerEntity = (ImageBannerBlockEntity)blockEntity;
            imageBannerEntity.setColor(color);
            imageBannerEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
        if ((blockEntity = level.getBlockEntity(clickedPos)) instanceof ImageWallBannerBlockEntity) {
            imageBannerEntity = (ImageWallBannerBlockEntity)blockEntity;
            imageBannerEntity.setColor(color);
            imageBannerEntity.setImageLocation(PicAxeItem.getURL(stack));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltip, tooltipFlag);
        tooltip.add((Component)Component.literal((String)"URL: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)PicAxeItem.getURL(stack)).withStyle(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.picaxe.when_used").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.picaxe.use_action").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"tooltip.picaxe.sneak_use_action").withStyle(ChatFormatting.YELLOW));
    }
}

