/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.items;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.jacobwasbeast.picaxe.ModItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SixSidedImageBlockItem
extends BlockItem
implements Equipable {
    public SixSidedImageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static ItemStack create(Map<Direction, String> imageUrls) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SIX_SIDED_IMAGE_BLOCK_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.putString("id", "picaxe:six_sided_image_block");
        for (Map.Entry<Direction, String> entry : imageUrls.entrySet()) {
            tag.putString("image_url_" + entry.getKey().getName(), entry.getValue());
        }
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        return stack;
    }

    public static Map<Direction, String> getImageUrls(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            CompoundTag tag = customData.copyTag();
            EnumMap<Direction, String> imageUrls = new EnumMap<Direction, String>(Direction.class);
            for (Direction dir : Direction.values()) {
                String url = tag.getString("image_url_" + dir.getName());
                if (url.isEmpty()) continue;
                imageUrls.put(dir, url);
            }
            return imageUrls;
        }
        return Collections.emptyMap();
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GENERIC;
    }
}

