/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jacobwasbeast.picaxe.utils.ImageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

public class ImageShieldItemRendererNeoForge
extends BlockEntityWithoutLevelRenderer {
    private static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace((String)"entity/shield_base"));
    private static final Material SHIELD_BASE_NOPATTEN = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace((String)"entity/shield_base_nopattern"));
    @Nullable
    private ModelPart plate;
    @Nullable
    private ModelPart handle;

    public ImageShieldItemRendererNeoForge() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    private void initializeModels() {
        if (this.plate == null || this.handle == null) {
            EntityModelSet modelSet = Minecraft.getInstance().getEntityModels();
            ModelPart shieldModel = modelSet.bakeLayer(ModelLayers.SHIELD);
            this.plate = shieldModel.getChild("plate");
            this.handle = shieldModel.getChild("handle");
        }
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        CompoundTag tag;
        String imageUrl;
        boolean isBlocking;
        this.initializeModels();
        if (this.plate == null || this.handle == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        boolean isGUI = displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.FIXED;
        Material baseMaterial = isGUI ? SHIELD_BASE : SHIELD_BASE_NOPATTEN;
        VertexConsumer baseConsumer = baseMaterial.buffer(buffer, RenderType::entitySolid);
        boolean bl = isBlocking = Minecraft.getInstance().player != null && Minecraft.getInstance().player.isUsingItem() && Minecraft.getInstance().player.getUseItem() == stack;
        if (isBlocking) {
            switch (displayContext) {
                case FIRST_PERSON_RIGHT_HAND: 
                case FIRST_PERSON_LEFT_HAND: {
                    poseStack.translate(0.0, 0.1, -0.4);
                    poseStack.mulPose(Axis.YP.rotationDegrees(10.0f));
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    poseStack.translate(0.4, -0.1, 0.0);
                    poseStack.mulPose(Axis.XN.rotationDegrees(-20.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(-45.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(20.0f));
                    break;
                }
                case THIRD_PERSON_LEFT_HAND: {
                    poseStack.translate(-0.4, -0.1, 0.0);
                    poseStack.mulPose(Axis.XN.rotationDegrees(-20.0f));
                    poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    poseStack.mulPose(Axis.XP.rotationDegrees(-45.0f));
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-20.0f));
                    break;
                }
            }
        }
        this.handle.render(poseStack, baseConsumer, packedLight, packedOverlay);
        this.plate.render(poseStack, baseConsumer, packedLight, packedOverlay);
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && !(imageUrl = (tag = customData.copyTag()).getString("imageLocation")).isBlank()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.translate(-0.5, (double)-0.88f, -0.5);
            ImageUtils.renderImageFromURL(poseStack, buffer, packedLight, packedOverlay, 0.0f, 0.63f, 1.25f, imageUrl);
        }
        poseStack.popPose();
    }
}

