/*
 * Decompiled with CFR 0.152.
 */
package net.jacobwasbeast.picaxe.network;

import dev.architectury.networking.NetworkManager;
import net.jacobwasbeast.picaxe.blocks.entities.ImageFrameBlockEntity;
import net.jacobwasbeast.picaxe.items.PicAxeItem;
import net.jacobwasbeast.picaxe.network.UpdateImageFramePayload;
import net.jacobwasbeast.picaxe.network.UpdatePicAxeUrlPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketHandler {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UpdatePicAxeUrlPayload.TYPE, UpdatePicAxeUrlPayload.CODEC, PacketHandler::handleUpdateUrl);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), UpdateImageFramePayload.TYPE, UpdateImageFramePayload.CODEC, PacketHandler::handleUpdateImageFrame);
    }

    private static void handleUpdateUrl(UpdatePicAxeUrlPayload payload, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        context.queue(() -> {
            ItemStack stack;
            if (player != null && (stack = player.getItemInHand(payload.hand())).getItem() instanceof PicAxeItem) {
                PicAxeItem.setURL(stack, payload.url());
            }
        });
    }

    private static void handleUpdateImageFrame(UpdateImageFramePayload payload, NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        context.queue(() -> {
            BlockEntity be;
            Level level;
            if (player != null && (level = player.level()).isLoaded(payload.pos()) && (be = level.getBlockEntity(payload.pos())) instanceof ImageFrameBlockEntity) {
                ImageFrameBlockEntity frameEntity = (ImageFrameBlockEntity)be;
                frameEntity.setConfiguration(payload.url(), payload.width(), payload.height(), payload.stretch());
            }
        });
    }
}

